/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import java.net.MalformedURLException;
import java.net.URL;

public class Image {
    private final URL url;
    private final String title;
    private final String caption;
    private final String geoLocation;
    private final URL license;

    public Image(String url) throws MalformedURLException {
        this(new URL(url));
    }

    public Image(URL url) {
        this.url = url;
        this.title = null;
        this.caption = null;
        this.geoLocation = null;
        this.license = null;
    }

    public Image(URL url, String title, String caption, String geoLocation, String license) throws MalformedURLException {
        this(url, title, caption, geoLocation, new URL(license));
    }

    public Image(URL url, String title, String caption, String geoLocation, URL license) {
        this.url = url;
        this.title = title;
        this.caption = caption;
        this.geoLocation = geoLocation;
        this.license = license;
    }

    public URL getUrl() {
        return this.url;
    }

    @Deprecated(since="2022-05-06")
    public String getTitle() {
        return this.title;
    }

    @Deprecated(since="2022-05-06")
    public String getCaption() {
        return this.caption;
    }

    @Deprecated(since="2022-05-06")
    public String getGeoLocation() {
        return this.geoLocation;
    }

    @Deprecated(since="2022-05-06")
    public URL getLicense() {
        return this.license;
    }

    public static class ImageBuilder {
        private final URL url;
        private String title;
        private String caption;
        private String geoLocation;
        private URL license;

        public ImageBuilder(String url) throws MalformedURLException {
            this(new URL(url));
        }

        public ImageBuilder(URL url) {
            this.url = url;
        }

        @Deprecated(since="2022-05-06")
        public ImageBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Deprecated(since="2022-05-06")
        public ImageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @Deprecated(since="2022-05-06")
        public ImageBuilder geoLocation(String geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        @Deprecated(since="2022-05-06")
        public ImageBuilder license(String license) throws MalformedURLException {
            return this.license(new URL(license));
        }

        @Deprecated(since="2022-05-06")
        public ImageBuilder license(URL license) {
            this.license = license;
            return this;
        }

        public Image build() {
            return new Image(this.url, this.title, this.caption, this.geoLocation, this.license);
        }
    }
}

