/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.SitemapException;
import com.redfin.sitemapgenerator.SitemapIndexUrl;
import com.redfin.sitemapgenerator.SitemapValidator;
import com.redfin.sitemapgenerator.UrlUtils;
import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SitemapIndexGenerator {
    private final URL baseUrl;
    private final File outFile;
    private final boolean allowEmptyIndex;
    private final List<SitemapIndexUrl> urls = new ArrayList<SitemapIndexUrl>();
    private final int maxUrls;
    private final W3CDateFormat dateFormat;
    private final Date defaultLastMod;
    private final boolean autoValidate;

    public SitemapIndexGenerator(URL baseUrl, File outFile) {
        this(new Options(baseUrl, outFile));
    }

    public SitemapIndexGenerator(String baseUrl, File outFile) throws MalformedURLException {
        this(new Options(baseUrl, outFile));
    }

    private SitemapIndexGenerator(Options options) {
        this.baseUrl = options.baseUrl;
        this.outFile = options.outFile;
        this.allowEmptyIndex = options.allowEmptyIndex;
        this.maxUrls = options.maxUrls;
        W3CDateFormat dateFormat = options.dateFormat;
        if (dateFormat == null) {
            dateFormat = new W3CDateFormat();
        }
        this.dateFormat = dateFormat;
        this.defaultLastMod = options.defaultLastMod;
        this.autoValidate = options.autoValidate;
    }

    public SitemapIndexGenerator addUrl(SitemapIndexUrl url) {
        UrlUtils.checkUrl(url.url, this.baseUrl);
        if (this.urls.size() >= this.maxUrls) {
            throw new SitemapException("More than " + this.maxUrls + " urls");
        }
        this.urls.add(url);
        return this;
    }

    public SitemapIndexGenerator addUrls(Iterable<? extends SitemapIndexUrl> urls) {
        for (SitemapIndexUrl sitemapIndexUrl : urls) {
            this.addUrl(sitemapIndexUrl);
        }
        return this;
    }

    public SitemapIndexGenerator addUrls(SitemapIndexUrl ... urls) {
        for (SitemapIndexUrl url : urls) {
            this.addUrl(url);
        }
        return this;
    }

    public SitemapIndexGenerator addUrls(String ... urls) throws MalformedURLException {
        for (String url : urls) {
            this.addUrl(url);
        }
        return this;
    }

    public SitemapIndexGenerator addUrl(String url) throws MalformedURLException {
        return this.addUrl(new SitemapIndexUrl(url));
    }

    public SitemapIndexGenerator addUrls(URL ... urls) {
        for (URL url : urls) {
            this.addUrl(url);
        }
        return this;
    }

    public SitemapIndexGenerator addUrl(URL url) {
        return this.addUrl(new SitemapIndexUrl(url));
    }

    public SitemapIndexGenerator addUrl(URL url, Date lastMod) {
        return this.addUrl(new SitemapIndexUrl(url, lastMod));
    }

    public SitemapIndexGenerator addUrl(String url, Date lastMod) throws MalformedURLException {
        return this.addUrl(new SitemapIndexUrl(url, lastMod));
    }

    public SitemapIndexGenerator addUrls(String prefix, String suffix, int count) {
        if (count == 0) {
            try {
                this.addUrl(new URL(this.baseUrl, prefix + suffix));
            }
            catch (MalformedURLException e) {
                throw new SitemapException(e);
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                String fileName = prefix + i + suffix;
                try {
                    this.addUrl(new URL(this.baseUrl, fileName));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new SitemapException(e);
                }
            }
        }
        return this;
    }

    public void write() {
        try {
            this.write(new FileWriter(this.outFile));
        }
        catch (IOException e) {
            throw new SitemapException("Problem writing sitemap index file " + this.outFile, e);
        }
    }

    private void write(OutputStreamWriter out) {
        if (!this.allowEmptyIndex && this.urls.isEmpty()) {
            throw new SitemapException("No URLs added, sitemap index would be empty; you must add some URLs with addUrls");
        }
        try (OutputStreamWriter outputStreamWriter = out;){
            this.writeSiteMap(out);
            out.flush();
            if (this.autoValidate) {
                SitemapValidator.validateSitemapIndex(this.outFile);
            }
        }
        catch (SAXException e) {
            throw new SitemapException("Problem validating sitemap index file (bug?)", e);
        }
        catch (IOException ex) {
            throw new SitemapException("Error writing to output", ex);
        }
    }

    public String writeAsString() {
        StringBuilder sb = new StringBuilder();
        this.writeAsString(sb);
        return sb.toString();
    }

    private void writeAsString(StringBuilder sb) {
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append(String.format("<sitemapindex xmlns=\"%s\">\n", "http://www.sitemaps.org/schemas/sitemap/0.9"));
        for (SitemapIndexUrl url : this.urls) {
            sb.append("  <sitemap>\n");
            sb.append("    <loc>");
            sb.append(UrlUtils.escapeXml(url.url.toString()));
            sb.append("</loc>\n");
            Date lastMod = url.lastMod;
            if (lastMod == null) {
                lastMod = this.defaultLastMod;
            }
            if (lastMod != null) {
                sb.append("    <lastmod>");
                sb.append(this.dateFormat.format(lastMod));
                sb.append("</lastmod>\n");
            }
            sb.append("  </sitemap>\n");
        }
        sb.append("</sitemapindex>");
    }

    private void writeSiteMap(OutputStreamWriter out) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.writeAsString(sb);
        out.write(sb.toString());
    }

    public static class Options {
        private final URL baseUrl;
        private final File outFile;
        private W3CDateFormat dateFormat = null;
        private boolean allowEmptyIndex = false;
        private int maxUrls = 50000;
        private Date defaultLastMod = new Date();
        private boolean autoValidate = false;

        public Options(URL baseUrl, File outFile) {
            this.baseUrl = baseUrl;
            this.outFile = outFile;
        }

        public Options(String baseUrl, File outFile) throws MalformedURLException {
            this(new URL(baseUrl), outFile);
        }

        public Options dateFormat(W3CDateFormat dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Options allowEmptyIndex(boolean allowEmptyIndex) {
            this.allowEmptyIndex = allowEmptyIndex;
            return this;
        }

        Options maxUrls(int maxUrls) {
            if (maxUrls > 50000) {
                throw new SitemapException(String.format("You can't have more than %d sitemaps per index", 50000));
            }
            this.maxUrls = maxUrls;
            return this;
        }

        public Options defaultLastMod(Date defaultLastMod) {
            this.defaultLastMod = defaultLastMod;
            return this;
        }

        public Options autoValidate(boolean autoValidate) {
            this.autoValidate = autoValidate;
            return this;
        }

        public SitemapIndexGenerator build() {
            return new SitemapIndexGenerator(this);
        }
    }
}

