/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.SitemapException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SitemapValidator {
    private static Schema sitemapSchema;
    private static Schema sitemapIndexSchema;

    private SitemapValidator() {
    }

    private static synchronized void lazyLoad() {
        if (sitemapSchema != null) {
            return;
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            sitemapSchema = SitemapValidator.lazyLoad(factory, "sitemap.xsd");
            sitemapIndexSchema = SitemapValidator.lazyLoad(factory, "siteindex.xsd");
        }
        catch (Exception e) {
            throw new SitemapException("BUG", e);
        }
    }

    private static synchronized Schema lazyLoad(SchemaFactory factory, String resource) throws IOException, SAXException {
        try (InputStream stream = SitemapValidator.class.getResourceAsStream(resource);){
            if (stream == null) {
                throw new SitemapException("BUG Couldn't load " + resource);
            }
            StreamSource source = new StreamSource(stream);
            Schema schema = factory.newSchema(source);
            return schema;
        }
    }

    public static void validateWebSitemap(File sitemap) throws SAXException {
        SitemapValidator.lazyLoad();
        SitemapValidator.validateXml(sitemap, sitemapSchema);
    }

    public static void validateSitemapIndex(File sitemap) throws SAXException {
        SitemapValidator.lazyLoad();
        SitemapValidator.validateXml(sitemap, sitemapIndexSchema);
    }

    private static void validateXml(File sitemap, Schema schema) throws SAXException {
        Validator validator = schema.newValidator();
        try (FileReader reader = new FileReader(sitemap);){
            SAXSource source = new SAXSource(new InputSource(reader));
            validator.validate(source);
        }
        catch (IOException e) {
            throw new SitemapException(e);
        }
    }
}

