/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.TimeZone;

public class W3CDateFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = -5733368073260485802L;
    private final Pattern pattern;
    public static final TimeZone ZULU = TimeZone.getTimeZone("GMT");

    public W3CDateFormat() {
        this(Pattern.AUTO);
    }

    public W3CDateFormat(Pattern pattern) {
        super(pattern.pattern);
        this.pattern = pattern;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        boolean includeTimeZone = this.pattern.includeTimeZone;
        if (this.pattern == Pattern.AUTO) {
            includeTimeZone = this.autoFormat(date);
        }
        super.format(date, toAppendTo, pos);
        if (includeTimeZone) {
            this.convertRfc822TimeZoneToW3c(toAppendTo);
        }
        return toAppendTo;
    }

    private boolean applyPattern(Pattern pattern) {
        this.applyPattern(pattern.pattern);
        return pattern.includeTimeZone;
    }

    private boolean autoFormat(Date date) {
        boolean hasTime;
        boolean hasSeconds;
        boolean hasMillis;
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar();
        }
        this.calendar.setTime(date);
        boolean bl = hasMillis = this.calendar.get(14) > 0;
        if (hasMillis) {
            return this.applyPattern(Pattern.MILLISECOND);
        }
        boolean bl2 = hasSeconds = this.calendar.get(13) > 0;
        if (hasSeconds) {
            return this.applyPattern(Pattern.SECOND);
        }
        boolean bl3 = hasTime = this.calendar.get(11) + this.calendar.get(12) > 0;
        if (hasTime) {
            return this.applyPattern(Pattern.MINUTE);
        }
        return this.applyPattern(Pattern.DAY);
    }

    @Override
    public Date parse(String text, ParsePosition pos) {
        text = this.convertW3cTimeZoneToRfc822(text);
        if (this.pattern == Pattern.AUTO) {
            return this.autoParse(text, pos);
        }
        return super.parse(text, pos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof W3CDateFormat)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        W3CDateFormat that = (W3CDateFormat)o;
        return this.pattern == that.pattern;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.pattern});
    }

    private Date autoParse(String text, ParsePosition pos) {
        for (Pattern pattern : Pattern.values()) {
            if (pattern == Pattern.AUTO) continue;
            this.applyPattern(pattern);
            Date out = super.parse(text, pos);
            if (out == null) continue;
            return out;
        }
        return null;
    }

    private void convertRfc822TimeZoneToW3c(StringBuffer toAppendTo) {
        int length = toAppendTo.length();
        if (ZULU.equals(this.calendar.getTimeZone())) {
            toAppendTo.replace(length - 5, length, "Z");
        } else {
            toAppendTo.insert(length - 2, ':');
        }
    }

    private String convertW3cTimeZoneToRfc822(String source) {
        int length = source.length();
        if (source.endsWith("Z")) {
            return source.substring(0, length - 1) + "+0000";
        }
        if (source.charAt(length - 3) == ':') {
            return source.substring(0, length - 3) + source.substring(length - 2);
        }
        return source;
    }

    public static enum Pattern {
        MILLISECOND("yyyy-MM-dd'T'HH:mm:ss.SSSZ", true),
        SECOND("yyyy-MM-dd'T'HH:mm:ssZ", true),
        MINUTE("yyyy-MM-dd'T'HH:mmZ", true),
        DAY("yyyy-MM-dd", false),
        MONTH("yyyy-MM", false),
        YEAR("yyyy", false),
        AUTO("", true);

        private final String pattern;
        private final boolean includeTimeZone;

        private Pattern(String pattern, boolean includeTimeZone) {
            this.pattern = pattern;
            this.includeTimeZone = includeTimeZone;
        }
    }
}

