/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.model.oaipmh;

import io.gdcc.xoai.model.oaipmh.verbs.Verb;
import io.gdcc.xoai.xml.XmlWritable;
import io.gdcc.xoai.xml.XmlWriter;
import io.gdcc.xoai.xmlio.exceptions.XmlWriteException;
import java.time.Instant;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;

public class Request
implements XmlWritable {
    private final String baseUrl;
    private final Map<Verb.Argument, String> arguments = new EnumMap<Verb.Argument, String>(Verb.Argument.class);
    private Verb.Type type;
    private Instant from;
    private Instant until;

    public Request(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Optional<Verb.Type> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<String> getVerb() {
        return Optional.ofNullable(this.arguments.get((Object)Verb.Argument.Verb));
    }

    public Request withVerb(Verb.Type type) {
        Objects.requireNonNull(type);
        this.type = type;
        this.arguments.put(Verb.Argument.Verb, type.displayName());
        return this;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.arguments.get((Object)Verb.Argument.Identifier));
    }

    public Request withIdentifier(String value) {
        this.arguments.put(Verb.Argument.Identifier, value);
        return this;
    }

    public Optional<String> getMetadataPrefix() {
        return Optional.ofNullable(this.arguments.get((Object)Verb.Argument.MetadataPrefix));
    }

    public Request withMetadataPrefix(String value) {
        this.arguments.put(Verb.Argument.MetadataPrefix, value);
        return this;
    }

    public Optional<Instant> getFrom() {
        return Optional.ofNullable(this.from);
    }

    public Request withFrom(Instant value) {
        this.from = value;
        return this;
    }

    public void saveRawFrom(String value) {
        this.arguments.put(Verb.Argument.From, value);
    }

    public String getRawFrom() {
        return this.arguments.get((Object)Verb.Argument.From);
    }

    public Optional<Instant> getUntil() {
        return Optional.ofNullable(this.until);
    }

    public Request withUntil(Instant value) {
        this.until = value;
        return this;
    }

    public void saveRawUntil(String value) {
        this.arguments.put(Verb.Argument.Until, value);
    }

    public String getRawUntil() {
        return this.arguments.get((Object)Verb.Argument.Until);
    }

    public Optional<String> getSet() {
        return Optional.ofNullable(this.arguments.get((Object)Verb.Argument.Set));
    }

    public Request withSet(String value) {
        this.arguments.put(Verb.Argument.Set, value);
        return this;
    }

    public Optional<String> getResumptionToken() {
        return Optional.ofNullable(this.arguments.get((Object)Verb.Argument.ResumptionToken));
    }

    public Request withResumptionToken(String value) {
        this.arguments.put(Verb.Argument.ResumptionToken, value);
        return this;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            writer.writeAttribute(Verb.Argument.Verb, this.getVerb());
            writer.writeAttribute(Verb.Argument.Identifier, this.getIdentifier());
            writer.writeAttribute(Verb.Argument.MetadataPrefix, this.getMetadataPrefix());
            writer.writeAttribute(Verb.Argument.From, this.getFrom());
            writer.writeAttribute(Verb.Argument.Until, this.getUntil());
            writer.writeAttribute(Verb.Argument.Set, this.getSet());
            writer.writeAttribute(Verb.Argument.ResumptionToken, this.getResumptionToken());
            writer.writeCharacters(this.getBaseUrl());
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }
}

