/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.model.oaipmh;

import io.gdcc.xoai.model.oaipmh.Granularity;
import io.gdcc.xoai.model.oaipmh.Request;
import io.gdcc.xoai.xml.XmlWritable;
import io.gdcc.xoai.xml.XmlWriter;
import io.gdcc.xoai.xmlio.exceptions.XmlWriteException;
import java.time.Instant;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;

public final class ResumptionToken
implements XmlWritable {
    private final Value value;
    private Instant expirationDate;
    private Long completeListSize;
    private Long cursor;

    public ResumptionToken(Value value) {
        this.value = value;
    }

    public ResumptionToken() {
        this.value = new Value();
    }

    public Value getValue() {
        return this.value;
    }

    public Instant getExpirationDate() {
        return this.expirationDate;
    }

    public ResumptionToken withExpirationDate(Instant value) {
        this.expirationDate = value;
        return this;
    }

    public Long getCompleteListSize() {
        return this.completeListSize;
    }

    public ResumptionToken withCompleteListSize(long value) {
        this.completeListSize = value;
        return this;
    }

    public Long getCursor() {
        return this.cursor;
    }

    public ResumptionToken withCursor(long value) {
        this.cursor = value;
        return this;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            if (this.expirationDate != null) {
                writer.writeAttribute("expirationDate", this.expirationDate, Granularity.Second);
            }
            if (this.completeListSize != null) {
                writer.writeAttribute("completeListSize", "" + this.completeListSize);
            }
            if (this.cursor != null) {
                writer.writeAttribute("cursor", "" + this.cursor);
            }
            if (this.value != null) {
                writer.write(this.value);
            }
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public static final class Value {
        private final Long offset;
        private final String set;
        private final Instant from;
        private final Instant until;
        private final String metadataPrefix;

        Value() {
            this.offset = null;
            this.metadataPrefix = null;
            this.set = null;
            this.until = null;
            this.from = null;
        }

        Value(Long offset, String set, Instant from, Instant until, String metadataPrefix) {
            this.offset = offset;
            this.set = set;
            this.from = from;
            this.until = until;
            this.metadataPrefix = metadataPrefix;
        }

        public boolean isEmpty() {
            return Objects.isNull(this.offset) && Objects.isNull(this.set) && Objects.isNull(this.from) && Objects.isNull(this.until) && Objects.isNull(this.metadataPrefix);
        }

        public Value next(long sum) {
            return new Value((this.offset == null ? 0L : this.offset) + sum, this.set, this.from, this.until, this.metadataPrefix);
        }

        public long getOffset() {
            return this.offset == null ? 0L : this.offset;
        }

        public String getSetSpec() {
            return this.set;
        }

        public Instant getFrom() {
            return this.from;
        }

        public Instant getUntil() {
            return this.until;
        }

        public String getMetadataPrefix() {
            return this.metadataPrefix;
        }

        public boolean hasOffset() {
            return this.offset != null;
        }

        public boolean hasSetSpec() {
            return this.set != null;
        }

        public boolean hasFrom() {
            return this.from != null;
        }

        public boolean hasUntil() {
            return this.until != null;
        }

        public boolean hasMetadataPrefix() {
            return this.metadataPrefix != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value value = (Value)o;
            return Objects.equals(this.getOffset(), value.getOffset()) && Objects.equals(this.getSetSpec(), value.getSetSpec()) && Objects.equals(this.getFrom(), value.getFrom()) && Objects.equals(this.getUntil(), value.getUntil()) && Objects.equals(this.getMetadataPrefix(), value.getMetadataPrefix());
        }

        public int hashCode() {
            return Objects.hash(this.getOffset(), this.getSetSpec(), this.getFrom(), this.getUntil(), this.getMetadataPrefix());
        }

        public String toString() {
            return "Value{offset=" + this.offset + ", set='" + this.set + "', from=" + this.from + ", until=" + this.until + ", metadataPrefix='" + this.metadataPrefix + "'}";
        }
    }

    public static final class ValueBuilder {
        private Long offset;
        private String set;
        private Instant from;
        private Instant until;
        private String metadataPrefix;

        public ValueBuilder withOffset(long integer) {
            this.offset = integer;
            return this;
        }

        public ValueBuilder withSetSpec(String setSpec) {
            this.set = setSpec;
            return this;
        }

        public ValueBuilder withFrom(Instant from) {
            this.from = from;
            return this;
        }

        public ValueBuilder withUntil(Instant until) {
            this.until = until;
            return this;
        }

        public ValueBuilder withMetadataPrefix(String metadataPrefix) {
            this.metadataPrefix = metadataPrefix;
            return this;
        }

        public Value build() {
            return new Value(this.offset, this.set, this.from, this.until, this.metadataPrefix);
        }

        public static Value build(Request request) {
            ValueBuilder tokenBuilder = new ValueBuilder();
            tokenBuilder.withOffset(0L);
            request.getMetadataPrefix().ifPresent(tokenBuilder::withMetadataPrefix);
            request.getFrom().ifPresent(tokenBuilder::withFrom);
            request.getUntil().ifPresent(tokenBuilder::withUntil);
            request.getSet().ifPresent(tokenBuilder::withSetSpec);
            return tokenBuilder.build();
        }
    }
}

