/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.model.oaipmh.results.record;

import io.gdcc.xoai.xml.XmlWritable;
import io.gdcc.xoai.xml.XmlWriter;
import io.gdcc.xoai.xmlio.exceptions.XmlWriteException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class Header
implements XmlWritable {
    protected String identifier;
    protected Instant datestamp;
    protected List<String> setSpecs = new ArrayList<String>();
    protected Status status;

    public String getIdentifier() {
        return this.identifier;
    }

    public Header withIdentifier(String value) {
        this.identifier = value;
        return this;
    }

    public Instant getDatestamp() {
        return this.datestamp;
    }

    public Header withDatestamp(Instant value) {
        this.datestamp = value;
        return this;
    }

    public List<String> getSetSpecs() {
        return this.setSpecs;
    }

    public Status getStatus() {
        return this.status;
    }

    public Header withStatus(Status value) {
        this.status = value;
        return this;
    }

    public Header withSetSpec(String setSpec) {
        this.setSpecs.add(setSpec);
        return this;
    }

    public boolean isDeleted() {
        return this.status != null;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            if (this.status != null) {
                writer.writeAttribute("status", this.status.value());
            }
            writer.writeElement("identifier", this.identifier);
            writer.writeElement("datestamp", this.datestamp);
            for (String setSpec : this.getSetSpecs()) {
                writer.writeElement("setSpec", setSpec);
            }
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public static enum Status {
        DELETED("deleted");

        private final String representation;

        private Status(String representation) {
            this.representation = representation;
        }

        public String value() {
            return this.representation;
        }

        public static Status fromRepresentation(String representation) {
            for (Status status : Status.values()) {
                if (!status.representation.equals(representation)) continue;
                return status;
            }
            throw new IllegalArgumentException(representation);
        }
    }
}

