/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.xml;

import io.gdcc.xoai.xml.XmlWritable;
import io.gdcc.xoai.xml.XmlWriter;
import io.gdcc.xoai.xmlio.XmlReader;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import io.gdcc.xoai.xmlio.exceptions.XmlWriteException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;

public class EchoElement
implements XmlWritable {
    private final Deque<Set<String>> declaredPrefixes = new ArrayDeque<Set<String>>();
    private final String xmlString;
    private final InputStream xmlInputStream;

    public EchoElement(String xmlString) {
        this.xmlString = xmlString;
        this.xmlInputStream = null;
    }

    public EchoElement(InputStream xmlInputStream) {
        this.xmlInputStream = xmlInputStream;
        this.xmlString = null;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        if (this.xmlInputStream != null) {
            this.write(writer, this.xmlInputStream);
        } else if (this.xmlString != null) {
            this.write(writer, new ByteArrayInputStream(this.xmlString.getBytes(StandardCharsets.UTF_8)));
        } else {
            throw new XmlWriteException("Cannot write XML when none given (both stream and string null)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write(XmlWriter writer, InputStream inStream) throws XmlWriteException {
        try (InputStream inputStream = inStream;
             XmlReader reader = new XmlReader(inStream);){
            block12: while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    this.declaredPrefixes.push(new HashSet());
                    QName name = event.asStartElement().getName();
                    writer.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
                    this.addNamespaceIfRequired(writer, name);
                    Iterator<Namespace> itNamespaces = event.asStartElement().getNamespaces();
                    while (itNamespaces.hasNext()) {
                        Namespace namespace = itNamespaces.next();
                        this.addNamespaceIfRequired(writer, new QName(namespace.getNamespaceURI(), "", namespace.getPrefix()));
                    }
                    Iterator<Attribute> itAttributes = event.asStartElement().getAttributes();
                    while (true) {
                        if (!itAttributes.hasNext()) continue block12;
                        Attribute attr = itAttributes.next();
                        QName attrName = attr.getName();
                        this.addNamespaceIfRequired(writer, attrName);
                        writer.writeAttribute(attrName.getPrefix(), attrName.getNamespaceURI(), attrName.getLocalPart(), attr.getValue());
                    }
                }
                if (event.isEndElement()) {
                    this.declaredPrefixes.pop();
                    writer.writeEndElement();
                    continue;
                }
                if (!event.isCharacters()) continue;
                writer.writeCharacters(event.asCharacters().getData());
            }
            return;
        }
        catch (XmlReaderException | IOException | XMLStreamException e) {
            throw new XmlWriteException("Error trying to write XML", e);
        }
    }

    private void addNamespaceIfRequired(XmlWriter writer, QName name) throws XMLStreamException {
        for (Set<String> ancestorNamespaces : this.declaredPrefixes) {
            if (!ancestorNamespaces.contains(name.getPrefix() + name.getNamespaceURI())) continue;
            return;
        }
        writer.writeNamespace(name.getPrefix(), name.getNamespaceURI());
        this.declaredPrefixes.peek().add(name.getPrefix() + name.getNamespaceURI());
    }
}

