/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.xml;

import io.gdcc.xoai.model.oaipmh.Granularity;
import io.gdcc.xoai.model.oaipmh.ResumptionToken;
import io.gdcc.xoai.model.oaipmh.verbs.Verb;
import io.gdcc.xoai.services.api.DateProvider;
import io.gdcc.xoai.xml.WriterContext;
import io.gdcc.xoai.xml.XmlWritable;
import io.gdcc.xoai.xmlio.XmlIoWriter;
import io.gdcc.xoai.xmlio.exceptions.XmlWriteException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;

public class XmlWriter
extends XmlIoWriter
implements AutoCloseable {
    private final WriterContext writerContext;

    public static String toString(XmlWritable writable) throws XMLStreamException {
        return XmlWriter.toString(writable, XmlWriter.defaultContext());
    }

    public static String toString(XmlWritable writable, WriterContext context) throws XMLStreamException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ByteArrayOutputStream byteArrayOutputStream = out;
             XmlWriter writer = new XmlWriter(out, context);){
            writable.write(writer);
        }
        catch (IOException e) {
            throw new XmlWriteException((Throwable)e);
        }
        return ((Object)out).toString();
    }

    public static WriterContext defaultContext() {
        return new WriterContext(){};
    }

    public XmlWriter(OutputStream output) throws XMLStreamException {
        super(output);
        this.writerContext = XmlWriter.defaultContext();
    }

    public XmlWriter(OutputStream output, WriterContext writerContext) throws XMLStreamException {
        super(output);
        this.writerContext = writerContext;
    }

    public WriterContext getWriterContext() {
        return this.writerContext;
    }

    public void writeDate(Instant date) throws XmlWriteException {
        try {
            this.writeCharacters(DateProvider.format(date, this.writerContext.getGranularity()));
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public void writeDate(Instant date, Granularity granularity) throws XmlWriteException {
        try {
            this.writeCharacters(DateProvider.format(date, granularity));
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public void writeElement(String elementName, String elementValue) throws XmlWriteException {
        try {
            this.writeStartElement(elementName);
            this.writeCharacters(elementValue);
            this.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public void writeElement(String elementName, XmlWritable writable) throws XmlWriteException {
        try {
            if (writable != null) {
                this.writeStartElement(elementName);
                writable.write(this);
                this.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public void writeElement(String elementName, Instant date, Granularity granularity) throws XmlWriteException {
        this.writeElement(elementName, DateProvider.format(date, granularity));
    }

    public void writeElement(String elementName, Instant date) throws XmlWriteException {
        this.writeElement(elementName, DateProvider.format(date, this.writerContext.getGranularity()));
    }

    public void writeAttribute(String name, Instant date) throws XmlWriteException {
        try {
            this.writeAttribute(name, DateProvider.format(date, this.writerContext.getGranularity()));
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public void writeAttribute(String name, Instant value, Granularity granularity) throws XmlWriteException {
        try {
            this.writeAttribute(name, DateProvider.format(value, granularity));
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public <T> void writeAttribute(Verb.Argument argument, Optional<T> optional) throws XMLStreamException {
        if (optional.isPresent()) {
            T value = optional.get();
            if (value instanceof String) {
                this.writeAttribute(argument.toString(), (String)value);
            } else if (value instanceof Instant) {
                this.writeAttribute(argument.toString(), (Instant)value);
            }
        }
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (value != null) {
            super.writeAttribute(localName, value);
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        if (text != null) {
            super.writeCharacters(text);
        }
    }

    public void write(XmlWritable writable) throws XmlWriteException {
        if (writable != null) {
            writable.write(this);
        }
    }

    public void write(ResumptionToken.Value value) throws XmlWriteException {
        try {
            if (!value.isEmpty()) {
                this.writeCharacters(this.writerContext.getResumptionTokenFormat().format(value));
            }
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public void writeStylesheet(String href) throws XMLStreamException {
        if (href == null) {
            throw new XMLStreamException("May not pass a null hyper reference to the XSLT processing instruction");
        }
        super.writeProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + href + "\"");
    }
}

