/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.services.api;

import io.gdcc.xoai.model.oaipmh.Granularity;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Map;

public interface DateProvider {
    public static final Map<Granularity, DateTimeFormatter> formatMap = Map.of(Granularity.Day, DateTimeFormatter.ofPattern("yyyy-MM-dd"), Granularity.Second, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"), Granularity.Lenient, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));

    public static Instant now() {
        return Instant.now().truncatedTo(ChronoUnit.SECONDS);
    }

    @Deprecated(since="2022-05-19", forRemoval=true)
    public static String format(Instant date) {
        return DateProvider.format(date, Granularity.Second);
    }

    public static String format(Instant date, Granularity granularity) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date, ZoneOffset.UTC);
        return formatMap.get((Object)granularity).format(dateTime);
    }

    public static Instant parse(String date, Granularity granularity) {
        if (granularity == Granularity.Day) {
            return LocalDate.parse(date, formatMap.get((Object)Granularity.Day)).atStartOfDay().toInstant(ZoneOffset.UTC);
        }
        try {
            return LocalDateTime.parse(date, formatMap.get((Object)Granularity.Second)).toInstant(ZoneOffset.UTC);
        }
        catch (DateTimeException e) {
            if (granularity == Granularity.Lenient) {
                return DateProvider.parse(date, Granularity.Day);
            }
            throw e;
        }
    }

    @Deprecated(since="2022-05-19", forRemoval=true)
    public static Instant parse(String string) {
        try {
            return Instant.parse(string);
        }
        catch (DateTimeException e) {
            return LocalDate.parse(string, formatMap.get((Object)Granularity.Day)).atStartOfDay().toInstant(ZoneOffset.UTC);
        }
    }
}

