/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.xml;

import io.gdcc.xoai.xml.XmlWritable;
import io.gdcc.xoai.xml.XmlWriter;
import io.gdcc.xoai.xmlio.exceptions.XmlWriteException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;

public class CopyElement
implements XmlWritable {
    protected final InputStream xmlInputStream;
    private static final Matcher xmlDeclaration = Pattern.compile("<\\?xml .*?\\?>").matcher("");

    public CopyElement(InputStream xmlInputStream) {
        Objects.requireNonNull(xmlInputStream);
        this.xmlInputStream = xmlInputStream;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            writer.writeCharacters("");
            writer.flush();
            this.writeXml(writer);
            writer.flush();
        }
        catch (IOException | XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    protected void writeXml(XmlWriter writer) throws IOException {
        try (InputStream inputStream = this.xmlInputStream;){
            byte[] buffer = this.xmlInputStream.readNBytes(1024);
            String firstChars = new String(buffer, StandardCharsets.UTF_8);
            firstChars = xmlDeclaration.reset(firstChars).replaceFirst("");
            writer.getOutputStream().write(firstChars.getBytes(StandardCharsets.UTF_8));
            this.xmlInputStream.transferTo(writer.getOutputStream());
        }
    }
}

