/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.model.oaipmh.verbs;

import io.gdcc.xoai.exceptions.BadArgumentException;
import io.gdcc.xoai.exceptions.BadVerbException;
import io.gdcc.xoai.xml.XmlWritable;
import java.util.Collections;
import java.util.Set;

public interface Verb
extends XmlWritable {
    public Type getType();

    public static enum Argument {
        From("from"),
        Until("until"),
        Identifier("identifier"),
        MetadataPrefix("metadataPrefix"),
        ResumptionToken("resumptionToken"),
        Set("set"),
        Verb("verb");

        private final String representation;

        private Argument(String rep) {
            this.representation = rep;
        }

        public String toString() {
            return this.representation;
        }

        public static Argument from(String representation) throws BadArgumentException {
            for (Argument param : Argument.values()) {
                if (!param.representation.equals(representation)) continue;
                return param;
            }
            throw new BadArgumentException("Given argument '" + representation + "' is not valid.");
        }
    }

    public static enum Type {
        GetRecord("GetRecord", Set.of(Argument.Identifier, Argument.MetadataPrefix), Set.of(), Set.of()),
        Identify("Identify", Set.of(), Set.of(), Set.of()),
        ListIdentifiers("ListIdentifiers", Set.of(Argument.MetadataPrefix), Set.of(Argument.From, Argument.Until, Argument.Set), Set.of(Argument.ResumptionToken)),
        ListMetadataFormats("ListMetadataFormats", Set.of(), Set.of(Argument.Identifier), Set.of()),
        ListRecords("ListRecords", Set.of(Argument.MetadataPrefix), Set.of(Argument.From, Argument.Until, Argument.Set), Set.of(Argument.ResumptionToken)),
        ListSets("ListSets", Set.of(), Set.of(), Set.of(Argument.ResumptionToken));

        private final String verb;
        private final Set<Argument> required;
        private final Set<Argument> optional;
        private final Set<Argument> exclusive;

        private Type(String value, Set<Argument> required, Set<Argument> optional, Set<Argument> exclusive) {
            this.verb = value;
            this.required = required;
            this.optional = optional;
            this.exclusive = exclusive;
        }

        public String displayName() {
            return this.verb;
        }

        public static Type from(String verb) throws BadVerbException {
            for (Type c : Type.values()) {
                if (!c.verb.equals(verb)) continue;
                return c;
            }
            throw new BadVerbException(verb);
        }

        public Set<Argument> reqArgs() {
            return Collections.unmodifiableSet(this.required);
        }

        public Set<Argument> optArgs() {
            return Collections.unmodifiableSet(this.optional);
        }

        public Set<Argument> exclArgs() {
            return Collections.unmodifiableSet(this.exclusive);
        }
    }
}

