/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.model.xoai;

import io.gdcc.xoai.model.xoai.Field;
import io.gdcc.xoai.xml.XmlWritable;
import io.gdcc.xoai.xml.XmlWriter;
import io.gdcc.xoai.xmlio.XmlReader;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import io.gdcc.xoai.xmlio.exceptions.XmlWriteException;
import io.gdcc.xoai.xmlio.matchers.AttributeMatchers;
import io.gdcc.xoai.xmlio.matchers.QNameMatchers;
import io.gdcc.xoai.xmlio.matchers.XmlEventMatchers;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class Element
implements XmlWritable {
    private static final String entityName = "element";
    protected List<Field> fields = new ArrayList<Field>();
    protected String name;
    protected List<Element> elements = new ArrayList<Element>();

    public static Element parse(XmlReader reader) throws XmlReaderException {
        if (!reader.current(AllOf.allOf((Matcher[])new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)entityName)))}))) {
            throw new XmlReaderException("Invalid XML. Expecting entity 'element'");
        }
        if (!reader.hasAttribute(AttributeMatchers.attributeName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"name"))))) {
            throw new XmlReaderException("Invalid XML. Element entities must have a name");
        }
        Element element = new Element(reader.getAttributeValue(QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"name"))));
        while (reader.next(new Matcher[]{XmlEventMatchers.anElement()}).current(XmlEventMatchers.aStartElement())) {
            if (reader.current(XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)entityName))))) {
                element.withElement(Element.parse(reader));
                continue;
            }
            if (reader.current(XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"field"))))) {
                element.withField(Field.parse(reader));
                continue;
            }
            throw new XmlReaderException("Unexpected element");
        }
        if (!reader.current(AllOf.allOf((Matcher[])new Matcher[]{XmlEventMatchers.anEndElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)entityName)))}))) {
            throw new XmlReaderException("Invalid XML. Expecting end of entity 'element'");
        }
        return element;
    }

    public Element(String name) {
        this.name = name;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public String getName() {
        return this.name;
    }

    public Element withName(String value) {
        this.name = value;
        return this;
    }

    public Element withField(Field field) {
        this.fields.add(field);
        return this;
    }

    public Element withField(String name, String value) {
        this.fields.add(new Field(value, name));
        return this;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public Element withElement(Element element) {
        this.elements.add(element);
        return this;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            if (this.name != null) {
                writer.writeAttribute("name", this.getName());
            }
            for (Field field : this.getFields()) {
                writer.writeStartElement("field");
                field.write(writer);
                writer.writeEndElement();
            }
            for (Element element : this.getElements()) {
                writer.writeStartElement(entityName);
                element.write(writer);
                writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }
}

