/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.services.impl;

import io.gdcc.xoai.model.xoai.Element;
import io.gdcc.xoai.model.xoai.Field;
import io.gdcc.xoai.model.xoai.XOAIMetadata;
import io.gdcc.xoai.services.api.MetadataSearch;
import io.gdcc.xoai.services.impl.AbstractMetadataSearcher;
import java.util.ArrayList;
import java.util.List;

public class MetadataSearchImpl
extends AbstractMetadataSearcher<String>
implements MetadataSearch<String> {
    public MetadataSearchImpl(XOAIMetadata metadata) {
        super(metadata);
    }

    @Override
    protected void consume(List<String> newNames, Element element) {
        ArrayList<String> names = new ArrayList<String>(newNames);
        names.add(element.getName());
        if (!element.getFields().isEmpty()) {
            for (Field field : element.getFields()) {
                if (field.getName() != null && !field.getName().equals("value")) {
                    this.add(String.join((CharSequence)".", names) + ":" + field.getName(), field.getValue());
                    continue;
                }
                this.add(String.join((CharSequence)".", names), field.getValue());
            }
        }
        if (!element.getElements().isEmpty()) {
            for (Element subElement : element.getElements()) {
                this.consume(names, subElement);
            }
        }
    }

    private void add(String name, String value) {
        this.index.computeIfAbsent(name, key -> new ArrayList());
        ((List)this.index.get(name)).add(value);
    }
}

