/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.services.impl;

import io.gdcc.xoai.model.xoai.Element;
import io.gdcc.xoai.model.xoai.Field;
import io.gdcc.xoai.model.xoai.MetadataItem;
import io.gdcc.xoai.model.xoai.XOAIMetadata;
import io.gdcc.xoai.services.api.MetadataSearch;
import io.gdcc.xoai.services.impl.AbstractMetadataSearcher;
import java.util.ArrayList;
import java.util.List;

public class MetadataSearcherItems
extends AbstractMetadataSearcher<MetadataItem>
implements MetadataSearch<MetadataItem> {
    public MetadataSearcherItems(XOAIMetadata metadata) {
        super(metadata);
    }

    @Override
    protected void consume(List<String> newNames, Element element) {
        ArrayList<String> names = new ArrayList<String>(newNames);
        names.add(element.getName());
        if (!element.getFields().isEmpty()) {
            this.add(String.join((CharSequence)".", names), element.getFields());
        }
        if (!element.getElements().isEmpty()) {
            for (Element subElement : element.getElements()) {
                this.consume(names, subElement);
            }
        }
    }

    private void add(String name, List<Field> fields) {
        MetadataItem newElement = new MetadataItem();
        for (Field field : fields) {
            if (field.getName() != null && !field.getName().equals("value")) {
                newElement.addProperty(field.getName(), field.getValue());
                continue;
            }
            newElement.setValue(field.getValue());
        }
        this.index.computeIfAbsent(name, key -> new ArrayList());
        ((List)this.index.get(name)).add(newElement);
    }
}

