/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.xml;

import io.gdcc.xoai.xml.XmlWritable;
import io.gdcc.xoai.xml.XmlWriter;
import io.gdcc.xoai.xmlio.exceptions.XmlWriteException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;

public class CopyElement
implements XmlWritable {
    protected final InputStream xmlInputStream;
    private static final Matcher xmlDeclaration = Pattern.compile("<\\?xml .*?\\?>").matcher("");

    public CopyElement(InputStream xmlInputStream) {
        Objects.requireNonNull(xmlInputStream);
        this.xmlInputStream = xmlInputStream;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            writer.writeCharacters("");
            writer.flush();
            this.writeXml(writer);
            writer.flush();
        }
        catch (IOException | XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    protected void writeXml(XmlWriter writer) throws IOException {
        try (InputStream inputStream = this.xmlInputStream;
             BufferedInputStream bufferedXmlInputStream = new BufferedInputStream(this.xmlInputStream);){
            int maxN;
            int n = 1024;
            bufferedXmlInputStream.mark(1025);
            byte[] bytes = bufferedXmlInputStream.readNBytes(1024);
            if (bytes.length == 1024 && (maxN = CopyElement.maxBytesWithCompleteUTF8Chars(bytes)) < 1024) {
                bufferedXmlInputStream.reset();
                bytes = bufferedXmlInputStream.readNBytes(maxN);
            }
            String firstChars = new String(bytes, StandardCharsets.UTF_8);
            firstChars = xmlDeclaration.reset(firstChars).replaceFirst("");
            writer.getOutputStream().write(firstChars.getBytes(StandardCharsets.UTF_8));
            bufferedXmlInputStream.transferTo(writer.getOutputStream());
        }
    }

    public static int maxBytesWithCompleteUTF8Chars(byte[] buffer) {
        int n = buffer.length;
        if (Byte.toUnsignedInt(buffer[n - 1]) > 127) {
            for (int i = n - 1; i > n - 5; --i) {
                if (Byte.toUnsignedInt(buffer[i]) <= 191) continue;
                return i;
            }
        }
        return n;
    }
}

