/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLPipeline {
    private final List<Transformer> transformers = new ArrayList<Transformer>();
    private final boolean omitXMLDeclaration;
    private InputStream inputStream;

    public XSLPipeline(InputStream inputStream, boolean omitXMLDeclaration) {
        this.inputStream = inputStream;
        this.omitXMLDeclaration = omitXMLDeclaration;
    }

    public XSLPipeline apply(Transformer xslTransformer) {
        if (xslTransformer == null) {
            return this;
        }
        this.transformers.add(xslTransformer);
        return this;
    }

    public InputStream process() throws TransformerException {
        for (Transformer transformer : this.transformers) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            transformer.setOutputProperty("omit-xml-declaration", this.omitXMLDeclaration ? "yes" : "no");
            transformer.transform(new StreamSource(this.inputStream), new StreamResult(outputStream));
            this.inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        }
        return this.inputStream;
    }
}

