/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.handlers;

import io.gdcc.xoai.dataprovider.exceptions.InternalOAIException;
import io.gdcc.xoai.dataprovider.exceptions.handler.DoesNotSupportSetsException;
import io.gdcc.xoai.dataprovider.exceptions.handler.HandlerException;
import io.gdcc.xoai.dataprovider.exceptions.handler.NoMatchesException;
import io.gdcc.xoai.dataprovider.handlers.VerbHandler;
import io.gdcc.xoai.dataprovider.model.Context;
import io.gdcc.xoai.dataprovider.model.Set;
import io.gdcc.xoai.dataprovider.repository.Repository;
import io.gdcc.xoai.dataprovider.repository.ResultsPage;
import io.gdcc.xoai.dataprovider.repository.SetRepository;
import io.gdcc.xoai.model.oaipmh.ResumptionToken;
import io.gdcc.xoai.model.oaipmh.verbs.ListSets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListSetsHandler
extends VerbHandler<ListSets> {
    private final SetRepository setRepository = this.getRepository().getSetRepository();

    public ListSetsHandler(Context context, Repository repository) {
        super(context, repository);
    }

    @Override
    public ListSets handle(ResumptionToken.Value token) throws HandlerException {
        if (token == null || token.isEmpty()) {
            throw new InternalOAIException("Resumption token must not be null or empty - check your implementation!");
        }
        if (!this.setRepository.supportSets()) {
            throw new DoesNotSupportSetsException();
        }
        List<Set> repositorySets = this.setRepository.getSets();
        List<Set> contextSets = this.getContext().getSets();
        int totalResults = repositorySets.size() + contextSets.size();
        int maxResults = this.getConfiguration().getMaxListSets();
        List pagedSetList = Stream.concat(contextSets.stream(), repositorySets.stream()).skip(token.getOffset()).limit(maxResults).collect(Collectors.toUnmodifiableList());
        ResultsPage results = new ResultsPage(token, pagedSetList.size() == maxResults && (long)totalResults != (long)maxResults + token.getOffset(), pagedSetList, totalResults);
        if (results.getTotal() == 0) {
            throw new NoMatchesException();
        }
        ListSets response = new ListSets();
        results.getList().forEach(item -> response.getSets().add(item.toOAIPMH()));
        results.getResponseToken(this.getConfiguration().getMaxListSets()).ifPresent(arg_0 -> ((ListSets)response).withResumptionToken(arg_0));
        return response;
    }
}

