/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.repository;

import io.gdcc.xoai.dataprovider.exceptions.InternalOAIException;
import io.gdcc.xoai.model.oaipmh.ResumptionToken;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ResultsPage<T> {
    private final boolean hasMore;
    private final List<T> resultsList;
    private final int totalResults;
    private final ResumptionToken.Value requestToken;

    public ResultsPage(ResumptionToken.Value requestToken, boolean hasMoreResults, List<T> resultsList, int totalResults) {
        Objects.requireNonNull(resultsList, "List of result may be empty but not null");
        if (totalResults < 0) {
            throw new InternalOAIException("Number of results may not be negative " + totalResults);
        }
        if (resultsList.size() > totalResults) {
            throw new InternalOAIException("Number of results (" + totalResults + ") may not be smaller than the list size " + resultsList.size());
        }
        if (resultsList.isEmpty() && totalResults > 0) {
            throw new InternalOAIException("Number of results (" + totalResults + ") may not be larger 0 with an empty result list");
        }
        if (resultsList.isEmpty() && hasMoreResults) {
            throw new InternalOAIException("Cannot indicate more results and have an empty result list");
        }
        Objects.requireNonNull(requestToken, "Resumption token may not be null");
        if (requestToken.isEmpty()) {
            throw new InternalOAIException("Result may not contain an empty resumption token");
        }
        this.requestToken = requestToken;
        this.hasMore = hasMoreResults;
        this.resultsList = Collections.unmodifiableList(resultsList);
        this.totalResults = totalResults;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public List<T> getList() {
        return this.resultsList;
    }

    public int getTotal() {
        return this.totalResults;
    }

    public ResumptionToken.Value getRequestTokenValue() {
        return this.requestToken;
    }

    public ResumptionToken.Value getResponseTokenValue() {
        return this.hasMore() ? this.requestToken.next((long)this.resultsList.size()) : new ResumptionToken.ValueBuilder().build();
    }

    public Optional<ResumptionToken> getResponseToken(int maxResponseLength) {
        return this.totalResults > maxResponseLength ? Optional.of(new ResumptionToken(this.getResponseTokenValue()).withCompleteListSize((long)this.totalResults).withCursor(this.requestToken.getOffset())) : Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultsPage)) {
            return false;
        }
        ResultsPage that = (ResultsPage)o;
        return this.hasMore == that.hasMore && this.totalResults == that.totalResults && this.resultsList.equals(that.resultsList) && this.requestToken.equals((Object)that.requestToken);
    }

    public int hashCode() {
        return Objects.hash(this.hasMore, this.resultsList, this.totalResults, this.requestToken);
    }
}

