/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.handlers;

import io.gdcc.xoai.dataprovider.exceptions.handler.CannotDisseminateFormatException;
import io.gdcc.xoai.dataprovider.exceptions.handler.HandlerException;
import io.gdcc.xoai.dataprovider.exceptions.handler.IdDoesNotExistException;
import io.gdcc.xoai.dataprovider.handlers.VerbHandler;
import io.gdcc.xoai.dataprovider.handlers.helpers.MetadataHelper;
import io.gdcc.xoai.dataprovider.model.Context;
import io.gdcc.xoai.dataprovider.model.Item;
import io.gdcc.xoai.dataprovider.model.MetadataFormat;
import io.gdcc.xoai.dataprovider.model.Set;
import io.gdcc.xoai.dataprovider.repository.Repository;
import io.gdcc.xoai.model.oaipmh.Request;
import io.gdcc.xoai.model.oaipmh.results.Record;
import io.gdcc.xoai.model.oaipmh.results.record.About;
import io.gdcc.xoai.model.oaipmh.results.record.Header;
import io.gdcc.xoai.model.oaipmh.results.record.Metadata;
import io.gdcc.xoai.model.oaipmh.verbs.GetRecord;
import java.util.Optional;

public final class GetRecordHandler
extends VerbHandler<GetRecord> {
    public GetRecordHandler(Context context, Repository repository) {
        super(context, repository);
    }

    @Override
    public GetRecord handle(Request request) throws HandlerException {
        String requestedFormat = (String)request.getMetadataPrefix().orElseThrow(() -> new CannotDisseminateFormatException("Missing required argument 'metadataPrefix'"));
        MetadataFormat format = Optional.ofNullable(this.getContext().formatForPrefix(requestedFormat)).orElseThrow(() -> new CannotDisseminateFormatException("Format '" + requestedFormat + "' not applicable in this context"));
        String identifier = (String)request.getIdentifier().orElseThrow(IdDoesNotExistException::new);
        Item item = this.getRepository().getItemRepository().getItem(identifier, format);
        if (item == null) {
            throw new IdDoesNotExistException();
        }
        if (!this.getContext().isItemShown(item)) {
            throw new IdDoesNotExistException("This context does not include this item");
        }
        if (!format.isItemShown(item)) {
            throw new CannotDisseminateFormatException("Format " + format.getPrefix() + " not applicable to this item");
        }
        Header header = new Header();
        Record record = new Record().withHeader(header);
        GetRecord result = new GetRecord(record);
        header.withIdentifier(item.getIdentifier());
        header.withDatestamp(item.getDatestamp());
        this.getContext().getSets().stream().filter(set -> set.isItemShown(item)).forEach(set -> header.withSetSpec(set.getSpec()));
        for (Set set2 : item.getSets()) {
            header.withSetSpec(set2.getSpec());
        }
        if (item.isDeleted()) {
            header.withStatus(Header.Status.DELETED);
        } else {
            Metadata metadata = item.getMetadata();
            if (!metadata.needsProcessing()) {
                record.withMetadata(metadata);
            } else {
                record.withMetadata(MetadataHelper.process(metadata, format, this.getContext()));
            }
            for (About about : item.getAbout()) {
                record.withAbout(about);
            }
        }
        return result;
    }
}

