/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.handlers;

import io.gdcc.xoai.dataprovider.exceptions.InternalOAIException;
import io.gdcc.xoai.dataprovider.exceptions.handler.HandlerException;
import io.gdcc.xoai.dataprovider.exceptions.handler.NoMatchesException;
import io.gdcc.xoai.dataprovider.filter.ScopedFilter;
import io.gdcc.xoai.dataprovider.handlers.VerbHandler;
import io.gdcc.xoai.dataprovider.handlers.helpers.MetadataHelper;
import io.gdcc.xoai.dataprovider.model.Context;
import io.gdcc.xoai.dataprovider.model.Item;
import io.gdcc.xoai.dataprovider.model.MetadataFormat;
import io.gdcc.xoai.dataprovider.model.Set;
import io.gdcc.xoai.dataprovider.repository.ItemRepository;
import io.gdcc.xoai.dataprovider.repository.Repository;
import io.gdcc.xoai.dataprovider.repository.ResultsPage;
import io.gdcc.xoai.model.oaipmh.ResumptionToken;
import io.gdcc.xoai.model.oaipmh.results.Record;
import io.gdcc.xoai.model.oaipmh.results.record.About;
import io.gdcc.xoai.model.oaipmh.results.record.Header;
import io.gdcc.xoai.model.oaipmh.results.record.Metadata;
import io.gdcc.xoai.model.oaipmh.verbs.ListRecords;
import java.util.List;
import java.util.stream.Stream;

public class ListRecordsHandler
extends VerbHandler<ListRecords> {
    private final ItemRepository itemRepository;

    public ListRecordsHandler(Context context, Repository repository) {
        super(context, repository);
        this.itemRepository = repository.getItemRepository();
    }

    @Override
    public ListRecords handle(ResumptionToken.Value token) throws HandlerException {
        if (token == null || token.isEmpty()) {
            throw new InternalOAIException("Resumption token must not be null or empty - check your implementation!");
        }
        this.verifySet(token);
        MetadataFormat format = this.verifyFormat(token);
        List<ScopedFilter> filters = this.createFilters(token, format);
        ResultsPage<Item> results = this.itemRepository.getItems(filters, format, this.getConfiguration().getMaxListRecords(), token);
        if (results.getTotal() == 0) {
            throw new NoMatchesException();
        }
        ListRecords response = new ListRecords();
        results.getList().forEach(item -> response.withRecord(this.createRecord((Item)item, format)));
        results.getResponseToken(this.getConfiguration().getMaxListRecords()).ifPresent(arg_0 -> ((ListRecords)response).withResumptionToken(arg_0));
        return response;
    }

    private Record createRecord(Item item, MetadataFormat format) {
        Header header = new Header();
        Record record = new Record().withHeader(header);
        header.withIdentifier(item.getIdentifier());
        header.withDatestamp(item.getDatestamp());
        Stream.concat(this.getContext().getSetsForItem(item), item.getSets().stream()).map(Set::getSpec).forEach(arg_0 -> ((Header)header).withSetSpec(arg_0));
        if (item.isDeleted()) {
            header.withStatus(Header.Status.DELETED);
        }
        if (!item.isDeleted()) {
            Metadata metadata = item.getMetadata();
            if (!metadata.needsProcessing()) {
                record.withMetadata(metadata);
            } else {
                record.withMetadata(MetadataHelper.process(metadata, format, this.getContext()));
            }
            for (About about : item.getAbout()) {
                record.withAbout(about);
            }
        }
        return record;
    }
}

