/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.handlers.helpers;

import io.gdcc.xoai.dataprovider.exceptions.InternalOAIException;
import io.gdcc.xoai.dataprovider.model.Context;
import io.gdcc.xoai.dataprovider.model.MetadataFormat;
import io.gdcc.xoai.model.oaipmh.results.record.Metadata;
import io.gdcc.xoai.xml.EchoElement;
import io.gdcc.xoai.xml.XSLPipeline;
import io.gdcc.xoai.xml.XmlWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;

public class MetadataHelper {
    /*
     * Enabled aggressive exception aggregation
     */
    public static Metadata process(Metadata metadata, MetadataFormat format, Context context) {
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            Metadata metadata2;
            try (XmlWriter writer = new XmlWriter((OutputStream)outStream);){
                metadata.write(writer);
                writer.flush();
                XSLPipeline pipeline = new XSLPipeline((InputStream)new ByteArrayInputStream(outStream.toByteArray()), true);
                EchoElement element = new EchoElement(pipeline.apply(context.getTransformer()).apply(format.getTransformer()).process());
                Metadata processed = new Metadata(element);
                metadata.getAttributes().ifPresent(a -> a.forEach((arg_0, arg_1) -> ((Metadata)processed).withAttribute(arg_0, arg_1)));
                metadata2 = processed;
            }
            return metadata2;
        }
        catch (IOException | XMLStreamException | TransformerException e) {
            throw new InternalOAIException(e);
        }
    }
}

