/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.request;

import io.gdcc.xoai.dataprovider.exceptions.InternalOAIException;
import io.gdcc.xoai.dataprovider.repository.RepositoryConfiguration;
import io.gdcc.xoai.exceptions.BadArgumentException;
import io.gdcc.xoai.exceptions.BadVerbException;
import io.gdcc.xoai.exceptions.OAIException;
import io.gdcc.xoai.model.oaipmh.Granularity;
import io.gdcc.xoai.model.oaipmh.Request;
import io.gdcc.xoai.model.oaipmh.verbs.Verb;
import io.gdcc.xoai.services.api.DateProvider;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class RequestBuilder {
    private RequestBuilder() {
    }

    public static RawRequest buildRawRequest(Map<String, String[]> parameters) throws OAIException {
        Objects.requireNonNull(parameters, "The parameter Map<String,String[]> must be non-null");
        RawRequest rawRequest = new RawRequest();
        if (!parameters.containsKey(Verb.Argument.Verb.toString())) {
            throw new BadVerbException("No argument '" + Verb.Argument.Verb + "' found");
        }
        Object[] verbParameter = parameters.get(Verb.Argument.Verb.toString());
        if (verbParameter == null || verbParameter.length != 1) {
            throw new BadVerbException("Verb must be singular, given: '" + Arrays.toString(verbParameter) + "'");
        }
        rawRequest.withVerb(Verb.Type.from((String)verbParameter[0]));
        Verb.Type verb = rawRequest.verb;
        HashSet<String> parameterKeys = new HashSet<String>(parameters.keySet());
        parameterKeys.remove(Verb.Argument.Verb.toString());
        for (String parameter : parameterKeys) {
            try {
                Verb.Argument argument = Verb.Argument.from((String)parameter);
                if (!(verb.reqArgs().contains(argument) || verb.optArgs().contains(argument) || verb.exclArgs().contains(argument))) {
                    throw new BadArgumentException("'" + argument + "' is not valid for verb '" + verb + "'");
                }
                Object[] argParameter = parameters.get(parameter);
                if (argParameter == null || argParameter.length != 1) {
                    throw new BadArgumentException("Arguments must be singular, given: '" + Arrays.toString(argParameter) + "'");
                }
                rawRequest.withArgument(argument, (String)argParameter[0]);
            }
            catch (BadArgumentException e) {
                rawRequest.withError(e);
            }
        }
        return rawRequest;
    }

    public static Request buildRequest(RawRequest rawRequest, RepositoryConfiguration configuration) {
        Request request = new Request(configuration.getBaseUrl());
        Granularity granularity = configuration.getGranularity();
        request.withVerb(rawRequest.getVerb());
        RequestBuilder.compileRequestArgument(request, rawRequest.getArguments(), granularity).forEach(rawRequest::withError);
        RequestBuilder.validateArgumentPresence(rawRequest.getVerb(), rawRequest.getArguments().keySet()).forEach(rawRequest::withError);
        RequestBuilder.verifyTimeArguments(request, configuration.getEarliestDate(), granularity, configuration.requiresFromAfterEarliest()).forEach(rawRequest::withError);
        if (rawRequest.hasErrors()) {
            return new Request(configuration.getBaseUrl());
        }
        request.getUntil().ifPresent(until -> request.withUntil(configuration.skewUntil((Instant)until)));
        return request;
    }

    public static List<BadArgumentException> compileRequestArgument(Request request, Map<Verb.Argument, String> arguments, Granularity granularity) {
        ArrayList<BadArgumentException> errors = new ArrayList<BadArgumentException>();
        for (Map.Entry<Verb.Argument, String> entry : arguments.entrySet()) {
            Verb.Argument argument = entry.getKey();
            String value = entry.getValue();
            try {
                switch (argument) {
                    case MetadataPrefix: {
                        request.withMetadataPrefix(value);
                        break;
                    }
                    case From: {
                        request.withFrom(DateProvider.parse((String)value, (Granularity)granularity));
                        request.saveRawFrom(value);
                        break;
                    }
                    case Until: {
                        request.withUntil(DateProvider.parse((String)value, (Granularity)granularity));
                        request.saveRawUntil(value);
                        break;
                    }
                    case Identifier: {
                        request.withIdentifier(value);
                        break;
                    }
                    case Set: {
                        request.withSet(value);
                        break;
                    }
                    case ResumptionToken: {
                        request.withResumptionToken(value);
                        break;
                    }
                    default: {
                        throw new InternalOAIException("This should never happen - do not include the verb in the arguments!");
                    }
                }
            }
            catch (DateTimeException e) {
                errors.add(new BadArgumentException("'" + value + "' is not a valid date for '" + argument + "' requiring format '" + granularity + "'"));
            }
        }
        return errors;
    }

    public static List<BadArgumentException> verifyTimeArguments(Request request, Instant earliestDate, Granularity granularity, boolean requireFromAfterEarliestDate) {
        Instant untilNotAfter;
        Instant fromNotAfter;
        ArrayList<BadArgumentException> errorList = new ArrayList<BadArgumentException>();
        Optional from = request.getFrom();
        Optional until = request.getUntil();
        if (from.isPresent() && until.isPresent()) {
            String rawFrom = request.getRawFrom();
            String rawUntil = request.getRawUntil();
            if (rawFrom == null || rawUntil == null || rawUntil.length() != rawFrom.length()) {
                errorList.add(new BadArgumentException("'from' and 'until' must be of same granularity"));
                return errorList;
            }
        }
        switch (granularity) {
            case Day: 
            case Lenient: {
                untilNotAfter = fromNotAfter = LocalDate.now(ZoneId.of("UTC")).atTime(LocalTime.MAX).toInstant(ZoneOffset.UTC);
                break;
            }
            default: {
                fromNotAfter = Instant.now();
                untilNotAfter = Instant.now().plus(2L, ChronoUnit.SECONDS);
            }
        }
        if (requireFromAfterEarliestDate && from.isPresent() && ((Instant)from.get()).isBefore(earliestDate)) {
            errorList.add(new BadArgumentException("'from' may not be before " + DateProvider.format((Instant)earliestDate, (Granularity)granularity)));
        }
        if (from.isPresent() && ((Instant)from.get()).isAfter(fromNotAfter)) {
            errorList.add(new BadArgumentException("'from' cannot not be after " + DateProvider.format((Instant)fromNotAfter, (Granularity)granularity)));
        }
        if (until.isPresent() && from.isPresent() && ((Instant)from.get()).isAfter((Instant)until.get())) {
            errorList.add(new BadArgumentException("'from' may not be after 'until'"));
        }
        if (until.isPresent() && ((Instant)until.get()).isAfter(untilNotAfter)) {
            errorList.add(new BadArgumentException("'until' cannot not be after " + DateProvider.format((Instant)untilNotAfter, (Granularity)granularity)));
        }
        return errorList;
    }

    public static List<BadArgumentException> validateArgumentPresence(Verb.Type verb, Set<Verb.Argument> arguments) {
        Objects.requireNonNull(verb, "Verb may not be null");
        Objects.requireNonNull(arguments, "Arguments may not be null");
        ArrayList<BadArgumentException> errors = new ArrayList<BadArgumentException>();
        HashSet<Verb.Argument> copy = new HashSet<Verb.Argument>(arguments);
        for (Verb.Argument argument : verb.exclArgs()) {
            if (!copy.contains(argument)) continue;
            if (copy.size() > 1) {
                errors.add(new BadArgumentException("Non-exclusive use of exclusive argument '" + argument + "'"));
            }
            return errors;
        }
        for (Verb.Argument argument : verb.reqArgs()) {
            if (!copy.contains(argument)) {
                errors.add(new BadArgumentException("Missing required argument '" + argument + "' for verb '" + verb + "'"));
            }
            copy.remove(argument);
        }
        for (Verb.Argument argument : verb.optArgs()) {
            copy.remove(argument);
        }
        if (!copy.isEmpty()) {
            copy.forEach(arg -> errors.add(new BadArgumentException("Argument '" + arg + "' not allowed for verb '" + verb + "'")));
        }
        return errors;
    }

    public static final class RawRequest {
        private Verb.Type verb;
        private final Map<Verb.Argument, String> arguments = new EnumMap<Verb.Argument, String>(Verb.Argument.class);
        private final List<BadArgumentException> errors = new ArrayList<BadArgumentException>();

        RawRequest() {
        }

        public RawRequest(Verb.Type verb) {
            this.withVerb(verb);
        }

        void withVerb(Verb.Type verb) {
            Objects.requireNonNull(verb);
            this.verb = verb;
        }

        public RawRequest withArgument(Verb.Argument argument, String value) {
            Objects.requireNonNull(argument);
            Objects.requireNonNull(value);
            this.arguments.put(argument, value);
            return this;
        }

        public void withError(BadArgumentException e) {
            Objects.requireNonNull(e);
            this.errors.add(e);
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public Verb.Type getVerb() {
            return this.verb;
        }

        public Map<Verb.Argument, String> getArguments() {
            return Collections.unmodifiableMap(this.arguments);
        }

        public List<BadArgumentException> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }
    }
}

