/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider;

import io.gdcc.xoai.model.oaipmh.results.MetadataFormat;
import io.gdcc.xoai.model.oaipmh.results.Record;
import io.gdcc.xoai.model.oaipmh.results.Set;
import io.gdcc.xoai.model.oaipmh.results.record.Header;
import io.gdcc.xoai.model.oaipmh.verbs.Identify;
import io.gdcc.xoai.serviceprovider.exceptions.BadArgumentException;
import io.gdcc.xoai.serviceprovider.exceptions.CannotDisseminateFormatException;
import io.gdcc.xoai.serviceprovider.exceptions.EncapsulatedKnownException;
import io.gdcc.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import io.gdcc.xoai.serviceprovider.exceptions.NoSetHierarchyException;
import io.gdcc.xoai.serviceprovider.handler.GetRecordHandler;
import io.gdcc.xoai.serviceprovider.handler.IdentifyHandler;
import io.gdcc.xoai.serviceprovider.handler.ListIdentifierHandler;
import io.gdcc.xoai.serviceprovider.handler.ListMetadataFormatsHandler;
import io.gdcc.xoai.serviceprovider.handler.ListRecordHandler;
import io.gdcc.xoai.serviceprovider.handler.ListSetsHandler;
import io.gdcc.xoai.serviceprovider.lazy.ItemIterator;
import io.gdcc.xoai.serviceprovider.model.Context;
import io.gdcc.xoai.serviceprovider.parameters.GetRecordParameters;
import io.gdcc.xoai.serviceprovider.parameters.ListIdentifiersParameters;
import io.gdcc.xoai.serviceprovider.parameters.ListMetadataParameters;
import io.gdcc.xoai.serviceprovider.parameters.ListRecordsParameters;
import java.util.Iterator;

public class ServiceProvider {
    private final Context context;
    private final ListMetadataFormatsHandler listMetadataFormatsHandler;
    private final IdentifyHandler identifyHandler;
    private final GetRecordHandler getRecordHandler;

    public ServiceProvider(Context context) {
        this.context = context;
        this.identifyHandler = new IdentifyHandler(context);
        this.listMetadataFormatsHandler = new ListMetadataFormatsHandler(context);
        this.getRecordHandler = new GetRecordHandler(context);
    }

    public Identify identify() {
        return this.identifyHandler.handle();
    }

    public Iterator<MetadataFormat> listMetadataFormats() throws IdDoesNotExistException {
        return this.listMetadataFormatsHandler.handle(ListMetadataParameters.request()).iterator();
    }

    public Iterator<MetadataFormat> listMetadataFormats(ListMetadataParameters parameters) throws IdDoesNotExistException {
        return this.listMetadataFormatsHandler.handle(parameters).iterator();
    }

    public Record getRecord(GetRecordParameters parameters) throws BadArgumentException, IdDoesNotExistException, CannotDisseminateFormatException {
        if (!parameters.areValid()) {
            throw new BadArgumentException("GetRecord verb requires identifier and metadataPrefix parameters");
        }
        return this.getRecordHandler.handle(parameters);
    }

    public Iterator<Record> listRecords(ListRecordsParameters parameters) throws BadArgumentException {
        if (!parameters.areValid()) {
            throw new BadArgumentException("ListRecords verb requires the metadataPrefix");
        }
        return new ItemIterator<Record>(new ListRecordHandler(this.context, parameters));
    }

    public Iterator<Header> listIdentifiers(ListIdentifiersParameters parameters) throws BadArgumentException {
        if (!parameters.areValid()) {
            throw new BadArgumentException("ListIdentifiers verb requires the metadataPrefix");
        }
        return new ItemIterator<Header>(new ListIdentifierHandler(this.context, parameters));
    }

    public Iterator<Set> listSets() throws NoSetHierarchyException {
        try {
            return new ItemIterator<Set>(new ListSetsHandler(this.context));
        }
        catch (EncapsulatedKnownException ex) {
            if (ex.getCause() instanceof NoSetHierarchyException) {
                throw (NoSetHierarchyException)ex.getCause();
            }
            throw ex;
        }
    }
}

