/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.client;

import io.gdcc.xoai.serviceprovider.client.OAIClient;
import io.gdcc.xoai.serviceprovider.exceptions.OAIRequestException;
import io.gdcc.xoai.serviceprovider.parameters.Parameters;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdkHttpOaiClient
extends OAIClient {
    private static final Logger log = LoggerFactory.getLogger((String)OAIClient.class.getCanonicalName());
    private final String baseUrl;
    private final String userAgent;
    private final Duration requestTimeout;
    private final HttpClient httpClient;
    private final Map<String, String> customHeaders;

    JdkHttpOaiClient(String baseUrl, String userAgent, Duration requestTimeout, Map<String, String> customHeaders, HttpClient httpClient) {
        this.baseUrl = baseUrl;
        this.userAgent = userAgent;
        this.requestTimeout = requestTimeout;
        this.customHeaders = Map.copyOf(customHeaders);
        this.httpClient = httpClient;
    }

    @Override
    public InputStream execute(Parameters parameters) throws OAIRequestException {
        try {
            URI requestURI = URI.create(parameters.toUrl(this.baseUrl));
            HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder().uri(requestURI).GET().header("User-Agent", this.userAgent).timeout(this.requestTimeout);
            this.customHeaders.forEach(httpRequestBuilder::header);
            HttpRequest request = httpRequestBuilder.build();
            HttpResponse<InputStream> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() == 200) {
                return response.body();
            }
            throw new OAIRequestException("Query faild with status code " + response.statusCode() + ": " + new String(response.body().readAllBytes(), StandardCharsets.UTF_8));
        }
        catch (IOException | IllegalArgumentException | InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new OAIRequestException(ex);
        }
    }

    public static final class JdkHttpBuilder
    implements OAIClient.Builder {
        private String baseUrl = "Must be set via Builder.withBaseUrl()";
        private String userAgent = "XOAI Service Provider v5";
        private Duration requestTimeout = Duration.ofSeconds(60L);
        private final Map<String, String> customHeaders = new HashMap<String, String>();
        private final HttpClient.Builder httpClientBuilder;

        JdkHttpBuilder() {
            this.httpClientBuilder = HttpClient.newBuilder();
        }

        public JdkHttpBuilder(HttpClient.Builder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
        }

        @Override
        public JdkHttpBuilder withBaseUrl(URL baseUrl) {
            return this.withBaseUrl(baseUrl.toString());
        }

        @Override
        public JdkHttpBuilder withBaseUrl(String baseUrl) {
            try {
                new URL(baseUrl).toURI();
                if (!baseUrl.startsWith("http")) {
                    throw new IllegalArgumentException("OAI-PMH supports HTTP/S only");
                }
                this.baseUrl = baseUrl;
                return this;
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public JdkHttpBuilder withConnectTimeout(Duration timeout) {
            this.httpClientBuilder.connectTimeout(timeout);
            return this;
        }

        @Override
        public JdkHttpBuilder withRequestTimeout(Duration timeout) {
            if (timeout == null || timeout.isNegative()) {
                throw new IllegalArgumentException("Timeout must not be null or negative value");
            }
            this.requestTimeout = timeout;
            return this;
        }

        @Override
        public JdkHttpBuilder withUserAgent(String userAgent) {
            if (userAgent == null || userAgent.isBlank()) {
                throw new IllegalArgumentException("User agent must not be null or empty/blank");
            }
            this.userAgent = userAgent;
            return this;
        }

        @Override
        public JdkHttpBuilder withFollowRedirects() {
            this.httpClientBuilder.followRedirects(HttpClient.Redirect.NORMAL);
            return this;
        }

        @Override
        public JdkHttpBuilder withInsecureSSL() {
            this.httpClientBuilder.sslContext(JdkHttpBuilder.insecureContext());
            if (!Boolean.getBoolean("jdk.internal.httpclient.disableHostnameVerification")) {
                log.warn("You must disable JDK HTTP Client Host Name Verification globally via system property -Djdk.internal.httpclient.disableHostnameVerification=true for XOAI Client connections to insecure SSL servers. Don't do this in a production setup!");
            }
            return this;
        }

        @Override
        public JdkHttpBuilder withCustomHeaders(Map<String, String> headers) {
            headers.forEach(this::withCustomHeader);
            return this;
        }

        @Override
        public OAIClient.Builder withCustomHeader(String header, String value) {
            Objects.requireNonNull(header, "Header name may not be null");
            Objects.requireNonNull(value, "Header's value for name \"" + header + "\" may not be null");
            if (header.isEmpty()) {
                throw new IllegalArgumentException("Found empty header name");
            }
            this.customHeaders.put(header, value);
            return this;
        }

        @Override
        public JdkHttpOaiClient build() {
            return new JdkHttpOaiClient(this.baseUrl, this.userAgent, this.requestTimeout, this.customHeaders, this.httpClientBuilder.build());
        }

        private static SSLContext insecureContext() {
            TrustManager[] noopTrustManager = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String string) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("TLSv1.2");
                sc.init(null, noopTrustManager, null);
                return sc;
            }
            catch (KeyManagementException | NoSuchAlgorithmException ex) {
                log.error("Could not build insecure SSL context. Might cause NPE.", (Throwable)ex);
                return null;
            }
        }
    }
}

