/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.client;

import io.gdcc.xoai.serviceprovider.client.JdkHttpOaiClient;
import io.gdcc.xoai.serviceprovider.exceptions.OAIRequestException;
import io.gdcc.xoai.serviceprovider.parameters.Parameters;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.util.Map;

public abstract class OAIClient {
    protected OAIClient() {
    }

    public static Builder newBuilder() {
        return new JdkHttpOaiClient.JdkHttpBuilder();
    }

    public abstract InputStream execute(Parameters var1) throws OAIRequestException;

    public static interface Builder {
        public Builder withBaseUrl(URL var1);

        public Builder withBaseUrl(String var1);

        public Builder withConnectTimeout(Duration var1);

        public Builder withRequestTimeout(Duration var1);

        public Builder withUserAgent(String var1);

        public Builder withFollowRedirects();

        public Builder withInsecureSSL();

        public Builder withCustomHeaders(Map<String, String> var1);

        public Builder withCustomHeader(String var1, String var2);

        public OAIClient build();
    }
}

