/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.handler;

import io.gdcc.xoai.model.oaipmh.results.record.Header;
import io.gdcc.xoai.model.oaipmh.verbs.Verb;
import io.gdcc.xoai.serviceprovider.client.OAIClient;
import io.gdcc.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import io.gdcc.xoai.serviceprovider.exceptions.OAIRequestException;
import io.gdcc.xoai.serviceprovider.lazy.Source;
import io.gdcc.xoai.serviceprovider.model.Context;
import io.gdcc.xoai.serviceprovider.parameters.ListIdentifiersParameters;
import io.gdcc.xoai.serviceprovider.parameters.Parameters;
import io.gdcc.xoai.serviceprovider.parsers.ListIdentifiersParser;
import io.gdcc.xoai.xmlio.XmlReader;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import io.gdcc.xoai.xmlio.matchers.QNameMatchers;
import io.gdcc.xoai.xmlio.matchers.XmlEventMatchers;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class ListIdentifierHandler
implements Source<Header> {
    private final ListIdentifiersParameters parameters;
    private final OAIClient client;
    private String resumptionToken = null;
    private boolean ended = false;

    public ListIdentifierHandler(Context context, ListIdentifiersParameters parameters) {
        this.parameters = parameters;
        this.client = context.getClient();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Header> nextIteration() {
        ArrayList<Header> headers = new ArrayList<Header>();
        Parameters requestParameters = Parameters.parameters().withVerb(Verb.Type.ListIdentifiers).include(this.parameters);
        if (this.resumptionToken != null) {
            requestParameters.withResumptionToken(this.resumptionToken);
        }
        try (InputStream stream = this.client.execute(requestParameters);){
            ArrayList<Header> arrayList;
            try (XmlReader reader = new XmlReader(stream);){
                ListIdentifiersParser parser = new ListIdentifiersParser(reader);
                while (parser.hasNext()) {
                    headers.add(parser.next());
                }
                if (reader.current(this.resumptionToken())) {
                    if (reader.next(new Matcher[]{XmlEventMatchers.text(), XmlEventMatchers.anEndElement()}).current(XmlEventMatchers.text())) {
                        String text = reader.getText();
                        if (text == null || "".equals(text.trim())) {
                            this.ended = true;
                        } else {
                            this.resumptionToken = text;
                        }
                    } else {
                        this.ended = true;
                    }
                } else {
                    this.ended = true;
                }
                arrayList = headers;
            }
            return arrayList;
        }
        catch (OAIRequestException | XmlReaderException | IOException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    private Matcher<XMLEvent> resumptionToken() {
        return AllOf.allOf((Matcher[])new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"resumptionToken")))});
    }

    @Override
    public boolean endReached() {
        return this.ended;
    }
}

