/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.handler;

import io.gdcc.xoai.model.oaipmh.results.Set;
import io.gdcc.xoai.model.oaipmh.verbs.Verb;
import io.gdcc.xoai.serviceprovider.client.OAIClient;
import io.gdcc.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import io.gdcc.xoai.serviceprovider.exceptions.OAIRequestException;
import io.gdcc.xoai.serviceprovider.lazy.Source;
import io.gdcc.xoai.serviceprovider.model.Context;
import io.gdcc.xoai.serviceprovider.parameters.Parameters;
import io.gdcc.xoai.serviceprovider.parsers.ListSetsParser;
import io.gdcc.xoai.xmlio.XmlReader;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import io.gdcc.xoai.xmlio.matchers.QNameMatchers;
import io.gdcc.xoai.xmlio.matchers.XmlEventMatchers;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class ListSetsHandler
implements Source<Set> {
    private final OAIClient client;
    private String resumptionToken;
    private boolean ended = false;

    public ListSetsHandler(Context context) {
        this.client = context.getClient();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Set> nextIteration() {
        Parameters requestParams = Parameters.parameters().withVerb(Verb.Type.ListSets);
        if (this.resumptionToken != null) {
            requestParams.withResumptionToken(this.resumptionToken);
        }
        try (InputStream stream = this.client.execute(requestParams);){
            List<Set> list;
            try (XmlReader reader = new XmlReader(stream);){
                List<Set> sets = new ListSetsParser(reader).parse();
                if (reader.current(this.resumptionToken())) {
                    if (reader.next(new Matcher[]{XmlEventMatchers.text(), XmlEventMatchers.anEndElement()}).current(XmlEventMatchers.text())) {
                        String text = reader.getText();
                        if (text == null || "".equals(text.trim())) {
                            this.ended = true;
                        } else {
                            this.resumptionToken = text;
                        }
                    } else {
                        this.ended = true;
                    }
                } else {
                    this.ended = true;
                }
                list = sets;
            }
            return list;
        }
        catch (OAIRequestException | XmlReaderException | IOException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    private Matcher<XMLEvent> resumptionToken() {
        return AllOf.allOf((Matcher[])new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"resumptionToken")))});
    }

    @Override
    public boolean endReached() {
        return this.ended;
    }
}

