/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.model;

import io.gdcc.xoai.model.oaipmh.Granularity;
import io.gdcc.xoai.serviceprovider.client.OAIClient;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public class Context {
    private static final TransformerFactory factory = TransformerFactory.newInstance();
    private Transformer transformer;
    private final Map<String, Transformer> metadataTransformers = new HashMap<String, Transformer>();
    private String baseUrl;
    private Granularity granularity;
    private OAIClient client;

    public Context() {
        try {
            this.withMetadataTransformer("xoai", factory.newTransformer());
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Unable to initialize identity transformer", e);
        }
    }

    public Context withTransformer(Transformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public boolean hasTransformer() {
        return this.transformer != null;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public boolean hasMetadataTransformerForPrefix(String prefix) {
        return this.metadataTransformers.containsKey(prefix);
    }

    public Context withMetadataTransformer(String prefix, Transformer transformer) {
        this.metadataTransformers.put(prefix, transformer);
        return this;
    }

    public Context withMetadataTransformer(String prefix, KnownTransformer knownTransformer) {
        return this.withMetadataTransformer(prefix, knownTransformer.transformer());
    }

    public Transformer getMetadataTransformer(String prefix) {
        return this.metadataTransformers.get(prefix);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Context withBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public Context withGranularity(Granularity granularity) {
        this.granularity = granularity;
        return this;
    }

    public Context withOAIClient(OAIClient client) {
        this.client = client;
        return this;
    }

    public OAIClient getClient() {
        return this.client;
    }

    public static enum KnownTransformer {
        OAI_DC("to_xoai/oai_dc.xsl");

        private final String location;

        private KnownTransformer(String location) {
            this.location = location;
        }

        public Transformer transformer() {
            try {
                return factory.newTransformer(new StreamSource(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.location)));
            }
            catch (TransformerConfigurationException e) {
                throw new IllegalStateException("Unable to load resource file '" + this.location + "'", e);
            }
        }
    }
}

