/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.parsers;

import io.gdcc.xoai.model.oaipmh.DeletedRecord;
import io.gdcc.xoai.model.oaipmh.Granularity;
import io.gdcc.xoai.model.oaipmh.results.Description;
import io.gdcc.xoai.model.oaipmh.verbs.Identify;
import io.gdcc.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import io.gdcc.xoai.serviceprovider.xml.IslandParsers;
import io.gdcc.xoai.xmlio.XmlReader;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import io.gdcc.xoai.xmlio.matchers.QNameMatchers;
import io.gdcc.xoai.xmlio.matchers.XmlEventMatchers;
import java.io.InputStream;
import java.time.Instant;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class IdentifyParser {
    private final XmlReader reader;

    public IdentifyParser(InputStream stream) {
        try {
            this.reader = new XmlReader(stream);
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    public Identify parse() {
        try {
            Identify identify = new Identify();
            this.reader.next(new Matcher[]{CoreMatchers.allOf((Matcher[])new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"Identify")))})});
            this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"repositoryName")))});
            identify.withRepositoryName(this.reader.next(new Matcher[]{XmlEventMatchers.text()}).getText());
            this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"baseURL")))});
            identify.withBaseURL(this.reader.next(new Matcher[]{XmlEventMatchers.text()}).getText());
            this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"protocolVersion")))});
            identify.withProtocolVersion(this.reader.next(new Matcher[]{XmlEventMatchers.text()}).getText());
            this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"adminEmail")))}).next(new Matcher[]{XmlEventMatchers.text()});
            identify.withAdminEmail(this.reader.getText());
            while (this.reader.next(new Matcher[]{XmlEventMatchers.aStartElement()}).current(XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"adminEmail"))))) {
                identify.withAdminEmail(this.reader.next(new Matcher[]{XmlEventMatchers.text()}).getText());
            }
            identify.withEarliestDatestamp((Instant)this.reader.next(new Matcher[]{XmlEventMatchers.text()}).get(IslandParsers.dateParser()));
            this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"deletedRecord")))}).next(new Matcher[]{XmlEventMatchers.text()});
            identify.withDeletedRecord(DeletedRecord.fromValue((String)this.reader.getText()));
            this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"granularity")))}).next(new Matcher[]{XmlEventMatchers.text()});
            identify.withGranularity(Granularity.fromRepresentation((String)this.reader.getText()));
            while (this.reader.next(new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.theEndOfDocument()}).current(XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"compression"))))) {
                identify.withCompression(this.reader.next(new Matcher[]{XmlEventMatchers.text()}).getText());
            }
            if (this.reader.current(XmlEventMatchers.theEndOfDocument())) {
                return identify;
            }
            if (this.reader.current(XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"description"))))) {
                identify.withDescription((Description)this.reader.get(this.descriptionParser()));
            }
            while (this.reader.next(new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.theEndOfDocument()}).current(XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"description"))))) {
                identify.withDescription((Description)this.reader.get(this.descriptionParser()));
            }
            return identify;
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    private XmlReader.IslandParser<Description> descriptionParser() {
        return reader -> new Description(reader.retrieveCurrentAsString());
    }
}

