/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.parsers;

import io.gdcc.xoai.model.oaipmh.Error;
import io.gdcc.xoai.model.oaipmh.results.Record;
import io.gdcc.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import io.gdcc.xoai.serviceprovider.model.Context;
import io.gdcc.xoai.serviceprovider.parsers.RecordParser;
import io.gdcc.xoai.xmlio.XmlReader;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import io.gdcc.xoai.xmlio.matchers.QNameMatchers;
import io.gdcc.xoai.xmlio.matchers.XmlEventMatchers;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ListRecordsParser {
    private final XmlReader reader;
    private final Context context;
    private final String metadataPrefix;
    private boolean awaitingNextInvocation = false;

    public ListRecordsParser(XmlReader reader, Context context, String metadataPrefix) {
        this.reader = reader;
        this.context = context;
        this.metadataPrefix = metadataPrefix;
    }

    public boolean hasNext() throws XmlReaderException {
        if (!this.awaitingNextInvocation) {
            this.reader.next(new Matcher[]{this.recordElement(), this.errorElement(), this.resumptionToken(), XmlEventMatchers.theEndOfDocument()});
        }
        this.awaitingNextInvocation = true;
        if (this.reader.current(this.errorElement())) {
            String code = this.reader.getAttributeValue(QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"code")));
            if (CoreMatchers.equalTo((Object)Error.Code.NO_RECORDS_MATCH.id()).matches((Object)code)) {
                return false;
            }
            throw new InvalidOAIResponse("OAI responded with code: " + code);
        }
        return this.reader.current(this.recordElement());
    }

    private Matcher<XMLEvent> resumptionToken() {
        return CoreMatchers.allOf((Matcher[])new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"resumptionToken")))});
    }

    public Record next() throws XmlReaderException {
        if (!this.hasNext()) {
            throw new XmlReaderException("No more records available");
        }
        this.awaitingNextInvocation = false;
        return new RecordParser(this.context, this.metadataPrefix).parse(this.reader);
    }

    private Matcher<XMLEvent> errorElement() {
        return XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"error")));
    }

    private Matcher<XMLEvent> recordElement() {
        return CoreMatchers.allOf((Matcher[])new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"record")))});
    }
}

