/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.parsers;

import io.gdcc.xoai.model.xoai.Element;
import io.gdcc.xoai.model.xoai.Field;
import io.gdcc.xoai.model.xoai.XOAIMetadata;
import io.gdcc.xoai.xmlio.XmlReader;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import io.gdcc.xoai.xmlio.matchers.QNameMatchers;
import io.gdcc.xoai.xmlio.matchers.XmlEventMatchers;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class MetadataParser {
    public XOAIMetadata parse(InputStream input) throws XmlReaderException {
        XOAIMetadata metadata = new XOAIMetadata();
        XmlReader reader = new XmlReader(input);
        reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"metadata")))});
        while (reader.next(new Matcher[]{XmlEventMatchers.theEndOfDocument(), XmlEventMatchers.anEndElement(), this.startElement()}).current(this.startElement())) {
            metadata.withElement(this.parseElement(reader));
        }
        return metadata;
    }

    private Element parseElement(XmlReader reader) throws XmlReaderException {
        Element element = new Element(reader.getAttributeValue(this.name()));
        while (reader.next(new Matcher[]{this.startElement(), this.startField(), this.endOfMetadata()}).current(this.startElement())) {
            element.withElement(this.parseElement(reader));
        }
        while (reader.current(this.startField())) {
            Field field = new Field().withName(reader.getAttributeValue(this.name()));
            if (reader.next(new Matcher[]{XmlEventMatchers.anEndElement(), XmlEventMatchers.text()}).current(XmlEventMatchers.text())) {
                field.withValue(reader.getText());
            }
            element.withField(field);
            reader.next(new Matcher[]{this.startField(), this.endElement()});
        }
        return element;
    }

    private Matcher<XMLEvent> startField() {
        return AllOf.allOf((Matcher[])new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"field")))});
    }

    private Matcher<XMLEvent> endOfMetadata() {
        return AllOf.allOf((Matcher[])new Matcher[]{XmlEventMatchers.anEndElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"metadata")))});
    }

    private Matcher<QName> name() {
        return QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"name"));
    }

    private Matcher<XMLEvent> startElement() {
        return AllOf.allOf((Matcher[])new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"element")))});
    }

    private Matcher<XMLEvent> endElement() {
        return AllOf.allOf((Matcher[])new Matcher[]{XmlEventMatchers.anEndElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"element")))});
    }
}

