/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.parsers;

import io.gdcc.xoai.model.oaipmh.results.Record;
import io.gdcc.xoai.model.oaipmh.results.record.About;
import io.gdcc.xoai.model.oaipmh.results.record.Metadata;
import io.gdcc.xoai.serviceprovider.exceptions.InternalHarvestException;
import io.gdcc.xoai.serviceprovider.model.Context;
import io.gdcc.xoai.serviceprovider.parsers.HeaderParser;
import io.gdcc.xoai.serviceprovider.parsers.MetadataParser;
import io.gdcc.xoai.xml.XSLPipeline;
import io.gdcc.xoai.xmlio.XmlReader;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import io.gdcc.xoai.xmlio.matchers.QNameMatchers;
import io.gdcc.xoai.xmlio.matchers.XmlEventMatchers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.TransformerException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class RecordParser {
    private final Context context;
    private String metadataPrefix;

    public RecordParser(Context context, String metadataPrefix) {
        this.context = context;
        this.metadataPrefix = metadataPrefix;
    }

    public Record parse(XmlReader reader) throws XmlReaderException {
        HeaderParser headerParser = new HeaderParser();
        reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"header")))});
        Record record = new Record().withHeader(headerParser.parse(reader));
        if (!record.getHeader().isDeleted()) {
            reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"metadata")))}).next(new Matcher[]{XmlEventMatchers.aStartElement()});
            String content = reader.retrieveCurrentAsString();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
            XSLPipeline pipeline = new XSLPipeline((InputStream)inputStream, true).apply(this.context.getMetadataTransformer(this.metadataPrefix));
            if (this.context.hasTransformer()) {
                pipeline.apply(this.context.getTransformer());
            }
            try {
                record.withMetadata(new Metadata(new MetadataParser().parse(pipeline.process())));
            }
            catch (TransformerException e) {
                throw new InternalHarvestException("Unable to process transformer", e);
            }
        }
        if (reader.next(new Matcher[]{this.aboutElement(), this.endOfRecord()}).current(this.aboutElement())) {
            reader.next(new Matcher[]{XmlEventMatchers.aStartElement()});
            record.withAbout(new About(reader.retrieveCurrentAsString()));
        }
        return record;
    }

    private Matcher<XMLEvent> endOfRecord() {
        return CoreMatchers.allOf((Matcher[])new Matcher[]{XmlEventMatchers.anEndElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"record")))});
    }

    private Matcher<XMLEvent> aboutElement() {
        return XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"about")));
    }
}

