/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.handler;

import io.gdcc.xoai.model.oaipmh.results.Record;
import io.gdcc.xoai.model.oaipmh.verbs.Verb;
import io.gdcc.xoai.serviceprovider.client.OAIClient;
import io.gdcc.xoai.serviceprovider.exceptions.CannotDisseminateFormatException;
import io.gdcc.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import io.gdcc.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import io.gdcc.xoai.serviceprovider.exceptions.OAIRequestException;
import io.gdcc.xoai.serviceprovider.model.Context;
import io.gdcc.xoai.serviceprovider.parameters.GetRecordParameters;
import io.gdcc.xoai.serviceprovider.parameters.Parameters;
import io.gdcc.xoai.serviceprovider.parsers.GetRecordParser;
import java.io.IOException;
import java.io.InputStream;

public class GetRecordHandler {
    private final OAIClient client;
    private final Context context;

    public GetRecordHandler(Context context) {
        this.context = context;
        this.client = context.getClient();
    }

    public Record handle(GetRecordParameters parameters) throws IdDoesNotExistException, CannotDisseminateFormatException {
        Record record;
        block8: {
            Parameters requestParameters = Parameters.parameters().withVerb(Verb.Type.GetRecord).include(parameters);
            InputStream stream = this.client.execute(requestParameters);
            try {
                record = new GetRecordParser(stream, this.context, parameters.getMetadataPrefix()).parse();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OAIRequestException | IOException e) {
                    throw new InvalidOAIResponse(e);
                }
            }
            stream.close();
        }
        return record;
    }
}

