/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.handler;

import io.gdcc.xoai.model.oaipmh.results.MetadataFormat;
import io.gdcc.xoai.model.oaipmh.verbs.Verb;
import io.gdcc.xoai.serviceprovider.client.OAIClient;
import io.gdcc.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import io.gdcc.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import io.gdcc.xoai.serviceprovider.exceptions.OAIRequestException;
import io.gdcc.xoai.serviceprovider.model.Context;
import io.gdcc.xoai.serviceprovider.parameters.ListMetadataParameters;
import io.gdcc.xoai.serviceprovider.parameters.Parameters;
import io.gdcc.xoai.serviceprovider.parsers.MetadataFormatParser;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ListMetadataFormatsHandler {
    private final OAIClient client;

    public ListMetadataFormatsHandler(Context context) {
        this.client = context.getClient();
    }

    public List<MetadataFormat> handle(ListMetadataParameters parameters) throws IdDoesNotExistException {
        ArrayList<MetadataFormat> arrayList;
        block9: {
            ArrayList<MetadataFormat> result = new ArrayList<MetadataFormat>();
            Parameters requestParameters = Parameters.parameters().withVerb(Verb.Type.ListMetadataFormats).include(parameters);
            InputStream stream = this.client.execute(requestParameters);
            try {
                MetadataFormatParser parser = new MetadataFormatParser(stream);
                while (parser.hasNext()) {
                    result.add(parser.next());
                }
                arrayList = result;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OAIRequestException | XmlReaderException | IOException e) {
                    throw new InvalidOAIResponse(e);
                }
            }
            stream.close();
        }
        return arrayList;
    }
}

