/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.handler;

import io.gdcc.xoai.model.oaipmh.results.Record;
import io.gdcc.xoai.model.oaipmh.verbs.Verb;
import io.gdcc.xoai.serviceprovider.client.OAIClient;
import io.gdcc.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import io.gdcc.xoai.serviceprovider.exceptions.OAIRequestException;
import io.gdcc.xoai.serviceprovider.lazy.Source;
import io.gdcc.xoai.serviceprovider.model.Context;
import io.gdcc.xoai.serviceprovider.parameters.ListRecordsParameters;
import io.gdcc.xoai.serviceprovider.parameters.Parameters;
import io.gdcc.xoai.serviceprovider.parsers.ListRecordsParser;
import io.gdcc.xoai.xmlio.XmlReader;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import io.gdcc.xoai.xmlio.matchers.QNameMatchers;
import io.gdcc.xoai.xmlio.matchers.XmlEventMatchers;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class ListRecordHandler
implements Source<Record> {
    private final Context context;
    private final ListRecordsParameters parameters;
    private final OAIClient client;
    private String resumptionToken;
    private boolean ended = false;

    public ListRecordHandler(Context context, ListRecordsParameters parameters) {
        this.context = context;
        this.parameters = parameters;
        this.client = context.getClient();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Record> nextIteration() {
        ArrayList<Record> records = new ArrayList<Record>();
        Parameters requestParameters = Parameters.parameters().withVerb(Verb.Type.ListRecords).include(this.parameters);
        if (this.resumptionToken != null) {
            requestParameters.withResumptionToken(this.resumptionToken);
        }
        try (InputStream stream = this.client.execute(requestParameters);){
            ArrayList<Record> arrayList;
            try (XmlReader reader = new XmlReader(stream);){
                ListRecordsParser parser = new ListRecordsParser(reader, this.context, this.parameters.getMetadataPrefix());
                while (parser.hasNext()) {
                    records.add(parser.next());
                }
                if (reader.current(this.resumptionToken())) {
                    if (reader.next(new Matcher[]{XmlEventMatchers.text(), XmlEventMatchers.anEndElement()}).current(XmlEventMatchers.text())) {
                        String text = reader.getText();
                        if (text == null || "".equals(text.trim())) {
                            this.ended = true;
                        } else {
                            this.resumptionToken = text;
                        }
                    } else {
                        this.ended = true;
                    }
                } else {
                    this.ended = true;
                }
                arrayList = records;
            }
            return arrayList;
        }
        catch (OAIRequestException | XmlReaderException | IOException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    private Matcher<XMLEvent> resumptionToken() {
        return AllOf.allOf((Matcher[])new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"resumptionToken")))});
    }

    @Override
    public boolean endReached() {
        return this.ended;
    }
}

