/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.parameters;

import io.gdcc.xoai.model.oaipmh.Granularity;
import io.gdcc.xoai.model.oaipmh.verbs.Verb;
import io.gdcc.xoai.serviceprovider.parameters.GetRecordParameters;
import io.gdcc.xoai.serviceprovider.parameters.ListIdentifiersParameters;
import io.gdcc.xoai.serviceprovider.parameters.ListMetadataParameters;
import io.gdcc.xoai.serviceprovider.parameters.ListRecordsParameters;
import io.gdcc.xoai.services.api.DateProvider;
import io.gdcc.xoai.util.URLEncoder;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.ArrayList;

public class Parameters {
    private Verb.Type verb = null;
    private String metadataPrefix = null;
    private String set = null;
    private Instant from = null;
    private Instant until = null;
    private String identifier = null;
    private String resumptionToken = null;
    private String granularity = null;

    public static Parameters parameters() {
        return new Parameters();
    }

    public Parameters withVerb(Verb.Type verb) {
        this.verb = verb;
        return this;
    }

    public Parameters withUntil(Instant until) {
        this.until = until;
        return this;
    }

    public Parameters withFrom(Instant from) {
        this.from = from;
        return this;
    }

    public Parameters withSet(String value) {
        this.set = value;
        return this;
    }

    public Parameters identifier(String value) {
        this.identifier = value;
        return this;
    }

    public Parameters withResumptionToken(String value) {
        this.resumptionToken = value;
        this.metadataPrefix = null;
        this.until = null;
        this.set = null;
        this.from = null;
        return this;
    }

    public Parameters withoutResumptionToken() {
        this.resumptionToken = null;
        return this;
    }

    public Parameters withMetadataPrefix(String value) {
        this.metadataPrefix = value;
        return this;
    }

    public String toUrl(String baseUrl) {
        ArrayList<CallSite> string = new ArrayList<CallSite>();
        string.add((CallSite)((Object)("verb=" + this.verb.name())));
        Granularity granularity = this.granularity();
        if (this.set != null) {
            string.add((CallSite)((Object)("set=" + URLEncoder.encode((String)this.set))));
        }
        if (this.from != null) {
            string.add((CallSite)((Object)("from=" + URLEncoder.encode((String)DateProvider.format((Instant)this.from, (Granularity)granularity)))));
        }
        if (this.until != null) {
            string.add((CallSite)((Object)("until=" + URLEncoder.encode((String)DateProvider.format((Instant)this.until, (Granularity)granularity)))));
        }
        if (this.identifier != null) {
            string.add((CallSite)((Object)("identifier=" + URLEncoder.encode((String)this.identifier))));
        }
        if (this.metadataPrefix != null) {
            string.add((CallSite)((Object)("metadataPrefix=" + URLEncoder.encode((String)this.metadataPrefix))));
        }
        if (this.resumptionToken != null) {
            string.add((CallSite)((Object)("resumptionToken=" + URLEncoder.encode((String)this.resumptionToken))));
        }
        return baseUrl + "?" + String.join((CharSequence)"&", string);
    }

    private Granularity granularity() {
        if (this.granularity != null) {
            for (int i = 0; i < Granularity.values().length; ++i) {
                Granularity possibleGranularity = Granularity.values()[i];
                if (!this.granularity.equals(possibleGranularity.toString())) continue;
                return possibleGranularity;
            }
        }
        return Granularity.Second;
    }

    public Parameters include(ListMetadataParameters parameters) {
        this.identifier = parameters.getIdentifier();
        return this;
    }

    public Parameters include(GetRecordParameters parameters) {
        this.identifier = parameters.getIdentifier();
        this.metadataPrefix = parameters.getMetadataPrefix();
        return this;
    }

    public Parameters include(ListRecordsParameters parameters) {
        this.metadataPrefix = parameters.getMetadataPrefix();
        this.set = parameters.getSetSpec();
        this.until = parameters.getUntil();
        this.from = parameters.getFrom();
        this.granularity = parameters.getGranularity();
        return this;
    }

    public Parameters include(ListIdentifiersParameters parameters) {
        this.metadataPrefix = parameters.getMetadataPrefix();
        this.set = parameters.getSetSpec();
        this.until = parameters.getUntil();
        this.from = parameters.getFrom();
        this.granularity = parameters.getGranularity();
        return this;
    }

    public Verb.Type getVerb() {
        return this.verb;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public String getSet() {
        return this.set;
    }

    public Instant getFrom() {
        return this.from;
    }

    public Instant getUntil() {
        return this.until;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getResumptionToken() {
        return this.resumptionToken;
    }

    public Parameters withGranularity(String granularity) {
        this.granularity = granularity;
        return this;
    }

    public Object getGranularity() {
        return this.granularity;
    }
}

