/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.parsers;

import io.gdcc.xoai.model.oaipmh.Error;
import io.gdcc.xoai.model.oaipmh.results.Record;
import io.gdcc.xoai.serviceprovider.exceptions.CannotDisseminateFormatException;
import io.gdcc.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import io.gdcc.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import io.gdcc.xoai.serviceprovider.model.Context;
import io.gdcc.xoai.serviceprovider.parsers.RecordParser;
import io.gdcc.xoai.xmlio.XmlReader;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import io.gdcc.xoai.xmlio.matchers.QNameMatchers;
import io.gdcc.xoai.xmlio.matchers.XmlEventMatchers;
import java.io.InputStream;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class GetRecordParser {
    private final XmlReader reader;
    private Context context;
    private String metadataPrefix;

    public GetRecordParser(InputStream stream, Context context, String metadataPrefix) {
        this.context = context;
        this.metadataPrefix = metadataPrefix;
        try {
            this.reader = new XmlReader(stream);
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    public Record parse() throws IdDoesNotExistException, CannotDisseminateFormatException {
        try {
            this.reader.next(new Matcher[]{this.errorElement(), this.recordElement()});
            if (this.reader.current(this.errorElement())) {
                String code = this.reader.getAttributeValue(QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"code")));
                if (Error.Code.ID_DOES_NOT_EXIST.id().equals(code)) {
                    throw new IdDoesNotExistException();
                }
                if (Error.Code.CANNOT_DISSEMINATE_FORMAT.id().equals(code)) {
                    throw new CannotDisseminateFormatException();
                }
                throw new InvalidOAIResponse("OAI responded with error code: " + code);
            }
            return new RecordParser(this.context, this.metadataPrefix).parse(this.reader);
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    private Matcher<XMLEvent> errorElement() {
        return XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"error")));
    }

    private Matcher<XMLEvent> recordElement() {
        return XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"record")));
    }
}

