/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.serviceprovider.parsers;

import io.gdcc.xoai.model.oaipmh.Error;
import io.gdcc.xoai.model.oaipmh.results.MetadataFormat;
import io.gdcc.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import io.gdcc.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import io.gdcc.xoai.xmlio.XmlReader;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import io.gdcc.xoai.xmlio.matchers.QNameMatchers;
import io.gdcc.xoai.xmlio.matchers.XmlEventMatchers;
import java.io.InputStream;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class MetadataFormatParser {
    private final XmlReader reader;
    private boolean awaitingNextInvocation = false;

    public MetadataFormatParser(InputStream inputStream) {
        try {
            this.reader = new XmlReader(inputStream);
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    public boolean hasNext() throws XmlReaderException, IdDoesNotExistException {
        if (!this.awaitingNextInvocation) {
            this.reader.next(new Matcher[]{this.metadataElement(), this.errorElement(), XmlEventMatchers.theEndOfDocument()});
            this.awaitingNextInvocation = true;
        }
        if (this.reader.current(this.errorElement())) {
            String code = this.reader.getAttributeValue(QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"code")));
            if (CoreMatchers.equalTo((Object)Error.Code.NO_METADATA_FORMATS.id()).matches((Object)code)) {
                return false;
            }
            if (Error.Code.ID_DOES_NOT_EXIST.id().equals(code)) {
                throw new IdDoesNotExistException();
            }
            throw new InvalidOAIResponse("OAI responded with code: " + code);
        }
        return this.reader.current(this.metadataElement());
    }

    private Matcher<XMLEvent> errorElement() {
        return XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"error")));
    }

    private Matcher<XMLEvent> metadataElement() {
        return CoreMatchers.allOf((Matcher[])new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"metadataFormat")))});
    }

    public MetadataFormat next() throws XmlReaderException, IdDoesNotExistException {
        if (!this.hasNext()) {
            throw new XmlReaderException("No more metadata elements available");
        }
        this.awaitingNextInvocation = false;
        return new MetadataFormat().withMetadataPrefix(this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"metadataPrefix")))}).next(new Matcher[]{XmlEventMatchers.text()}).getText()).withSchema(this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"schema")))}).next(new Matcher[]{XmlEventMatchers.text()}).getText()).withMetadataNamespace(this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"metadataNamespace")))}).next(new Matcher[]{XmlEventMatchers.text()}).getText());
    }
}

