/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.xmlio;

import io.gdcc.xoai.xmlio.XmlIoWriter;
import io.gdcc.xoai.xmlio.exceptions.XmlReaderException;
import io.gdcc.xoai.xmlio.matchers.XmlEventMatchers;
import io.gdcc.xoai.xmlio.matchers.extractor.ExtractFunction;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLInputFactory2;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class XmlReader
implements AutoCloseable {
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory2.newFactory();
    private final XMLEventReader xmlEventParser;

    public XmlReader(InputStream stream) throws XmlReaderException {
        try {
            this.xmlEventParser = XML_INPUT_FACTORY.createXMLEventReader(stream);
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException(e);
        }
    }

    public boolean current(Matcher<XMLEvent> matcher) throws XmlReaderException {
        return matcher.matches((Object)this.peek());
    }

    @Override
    public void close() throws XmlReaderException {
        try {
            this.xmlEventParser.close();
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException(e);
        }
    }

    public QName getName() throws XmlReaderException {
        if (this.peek().isStartElement()) {
            return this.peek().asStartElement().getName();
        }
        if (this.peek().isEndElement()) {
            return this.peek().asEndElement().getName();
        }
        throw new XmlReaderException("Current event has no name");
    }

    public String getText() throws XmlReaderException {
        if (this.current(XmlEventMatchers.text())) {
            return this.peek().asCharacters().getData();
        }
        throw new XmlReaderException("Current element is not text");
    }

    public String getAttributeValue(Matcher<QName> nameMatcher) throws XmlReaderException {
        if (this.peek().isStartElement()) {
            Iterator<Attribute> attributes = this.peek().asStartElement().getAttributes();
            while (attributes.hasNext()) {
                Attribute attribute = attributes.next();
                if (!nameMatcher.matches((Object)attribute.getName())) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public <T> Map<T, String> getAttributes(ExtractFunction<QName, T> extractFunction) throws XmlReaderException {
        HashMap map = new HashMap();
        if (this.peek().isStartElement()) {
            Iterator<Attribute> attributes = this.peek().asStartElement().getAttributes();
            while (attributes.hasNext()) {
                Attribute attribute = attributes.next();
                map.put(extractFunction.apply(attribute.getName()), attribute.getValue());
            }
        }
        return map;
    }

    public boolean hasAttribute(Matcher<Attribute> matcher) throws XmlReaderException {
        return this.hasAttributeMatcher(matcher).matches(this.peek().asStartElement().getAttributes());
    }

    private TypeSafeMatcher<Iterator<Attribute>> hasAttributeMatcher(final Matcher<Attribute> matcher) {
        return new TypeSafeMatcher<Iterator<Attribute>>(){

            public void describeTo(Description description) {
                description.appendText("has attribute");
            }

            protected boolean matchesSafely(Iterator item) {
                while (item.hasNext()) {
                    if (!matcher.matches(item.next())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    public final XmlReader next(Matcher<XMLEvent> ... possibleEvents) throws XmlReaderException {
        try {
            this.xmlEventParser.nextEvent();
            while (!CoreMatchers.anyOf(possibleEvents).matches((Object)this.peek())) {
                this.xmlEventParser.nextEvent();
            }
            return this;
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException(e);
        }
    }

    public <T> T get(IslandParser<T> islandParser) throws XmlReaderException {
        return islandParser.parse(this);
    }

    private XMLEvent peek() throws XmlReaderException {
        try {
            return this.xmlEventParser.peek();
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException(e);
        }
    }

    public XMLEvent nextEvent() throws XmlReaderException {
        try {
            return this.xmlEventParser.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException(e);
        }
    }

    public boolean hasNext() {
        return this.xmlEventParser.hasNext();
    }

    public String retrieveCurrentAsString() throws XmlReaderException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (this.current((Matcher<XMLEvent>)CoreMatchers.not(XmlEventMatchers.aStartElement()))) {
                throw new XmlReaderException("Can only retrieve from starting elements");
            }
            XmlIoWriter writer = new XmlIoWriter(outputStream);
            int depth = 0;
            while (this.xmlEventParser.peek() != null) {
                XMLEvent event = this.xmlEventParser.peek();
                if (event.isStartElement()) {
                    ++depth;
                    StartElement start = event.asStartElement();
                    writer.writeStartElement(start.getName().getPrefix(), start.getName().getLocalPart(), start.getName().getNamespaceURI());
                    Iterator<Namespace> it = start.getNamespaces();
                    while (it.hasNext()) {
                        Namespace n = it.next();
                        writer.writeNamespace(n.getPrefix(), n.getNamespaceURI());
                    }
                    Iterator<Attribute> attrs = start.getAttributes();
                    while (attrs.hasNext()) {
                        Attribute attr = attrs.next();
                        writer.writeAttribute(attr.getName().getPrefix(), attr.getName().getNamespaceURI(), attr.getName().getLocalPart(), attr.getValue());
                    }
                } else if (event.isEndElement()) {
                    writer.writeEndElement();
                    if (--depth == 0) {
                        break;
                    }
                } else if (event.isCharacters()) {
                    writer.writeCharacters(event.asCharacters().getData());
                }
                if (!this.xmlEventParser.hasNext()) break;
                this.xmlEventParser.nextEvent();
            }
            if (depth > 0) {
                throw new XmlReaderException("Unterminated structure");
            }
            writer.flush();
            writer.close();
            return outputStream.toString();
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException(e);
        }
    }

    public static interface IslandParser<T> {
        public T parse(XmlReader var1) throws XmlReaderException;
    }
}

