/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.xmlio.matchers;

import io.gdcc.xoai.xmlio.matchers.extractor.ExtractFunction;
import io.gdcc.xoai.xmlio.matchers.extractor.MatcherExtractor;
import javax.xml.namespace.QName;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.AnyOf;

public class XmlEventMatchers {
    public static Matcher<XMLEvent> text() {
        return new TypeSafeMatcher<XMLEvent>(){

            protected boolean matchesSafely(XMLEvent item) {
                return item.isCharacters();
            }

            public void describeTo(Description description) {
                description.appendText("is text");
            }
        };
    }

    public static Matcher<XMLEvent> aStartElement() {
        return new TypeSafeMatcher<XMLEvent>(){

            protected boolean matchesSafely(XMLEvent item) {
                return item.isStartElement();
            }

            public void describeTo(Description description) {
                description.appendText("is start element");
            }
        };
    }

    public static Matcher<XMLEvent> anEndElement() {
        return new TypeSafeMatcher<XMLEvent>(){

            protected boolean matchesSafely(XMLEvent item) {
                return item.isEndElement();
            }

            public void describeTo(Description description) {
                description.appendText("is end element");
            }
        };
    }

    public static Matcher<XMLEvent> theEndOfDocument() {
        return new TypeSafeMatcher<XMLEvent>(){

            protected boolean matchesSafely(XMLEvent item) {
                return item.isEndDocument();
            }

            public void describeTo(Description description) {
                description.appendText("is the end of the document");
            }
        };
    }

    public static Matcher<XMLEvent> theStartOfDocument() {
        return new TypeSafeMatcher<XMLEvent>(){

            protected boolean matchesSafely(XMLEvent item) {
                return item.isStartDocument();
            }

            public void describeTo(Description description) {
                description.appendText("is the start of the document");
            }
        };
    }

    public static Matcher<XMLEvent> anElement() {
        return AnyOf.anyOf((Matcher[])new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.anEndElement()});
    }

    public static Matcher<XMLEvent> anElementOr(Matcher<XMLEvent> matcher) {
        return AnyOf.anyOf((Matcher[])new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.anEndElement(), matcher});
    }

    public static Matcher<XMLEvent> hasAttributes() {
        return new TypeSafeMatcher<XMLEvent>(){

            protected boolean matchesSafely(XMLEvent item) {
                return XmlEventMatchers.aStartElement().matches((Object)item) && item.asStartElement().getAttributes().hasNext();
            }

            public void describeTo(Description description) {
                description.appendText("has attributes");
            }
        };
    }

    public static Matcher<XMLEvent> elementName(Matcher<QName> nameMatcher) {
        return new MatcherExtractor<XMLEvent, QName>(nameMatcher, XmlEventMatchers.extractName());
    }

    private static ExtractFunction<XMLEvent, QName> extractName() {
        return new ExtractFunction<XMLEvent, QName>(){

            @Override
            public QName apply(XMLEvent input) {
                if (input.isStartElement()) {
                    return input.asStartElement().getName();
                }
                if (input.isEndElement()) {
                    return input.asEndElement().getName();
                }
                return null;
            }

            public void describeTo(Description description) {
                description.appendText("name");
            }
        };
    }
}

