/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.snowflake.impl;

import io.geewit.snowflake.BitsAllocator;
import io.geewit.snowflake.UidGenerator;
import io.geewit.snowflake.exception.UidGenerateException;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUidGenerator
implements UidGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUidGenerator.class);
    protected int timeBits = 28;
    protected int workerBits = 22;
    protected int seqBits = 13;
    protected String epochStr = "2016-05-20";
    protected long epochSeconds = TimeUnit.MILLISECONDS.toSeconds(1463673600000L);
    protected BitsAllocator bitsAllocator = new BitsAllocator(this.timeBits, this.workerBits, this.seqBits);
    protected long workerId;
    protected long sequence = 0L;
    protected long lastSecond = -1L;

    public DefaultUidGenerator(long workerId) {
        this.workerId = workerId;
        if (this.workerId > this.bitsAllocator.getMaxWorkerId()) {
            throw new RuntimeException("Worker id " + this.workerId + " exceeds the max " + this.bitsAllocator.getMaxWorkerId());
        }
        logger.info("Initialized bits(1, {}, {}, {}) for workerID:{}", new Object[]{this.timeBits, this.workerBits, this.seqBits, this.workerId});
    }

    @Override
    public long getUID() throws UidGenerateException {
        try {
            return this.nextId();
        }
        catch (Exception e) {
            logger.error("Generate unique id exception.", (Throwable)e);
            throw new UidGenerateException(e);
        }
    }

    @Override
    public String parseUID(long uid) {
        long totalBits = 64L;
        long signBits = this.bitsAllocator.getSignBits();
        long timestampBits = this.bitsAllocator.getTimestampBits();
        long workerIdBits = this.bitsAllocator.getWorkerIdBits();
        long sequenceBits = this.bitsAllocator.getSequenceBits();
        long sequence = uid << (int)(totalBits - sequenceBits) >>> (int)(totalBits - sequenceBits);
        long workerId = uid << (int)(timestampBits + signBits) >>> (int)(totalBits - workerIdBits);
        long deltaSeconds = uid >>> (int)(workerIdBits + sequenceBits);
        Date thatTime = new Date(TimeUnit.SECONDS.toMillis(this.epochSeconds + deltaSeconds));
        String thatTimeStr = String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", thatTime);
        return String.format("{\"UID\":\"%d\",\"timestamp\":\"%s\",\"workerId\":\"%d\",\"sequence\":\"%d\"}", uid, thatTimeStr, workerId, sequence);
    }

    protected synchronized long nextId() {
        long currentSecond = this.getCurrentSecond();
        if (currentSecond < this.lastSecond) {
            long refusedSeconds = this.lastSecond - currentSecond;
            throw new UidGenerateException("Clock moved backwards. Refusing for %d seconds", refusedSeconds);
        }
        if (currentSecond == this.lastSecond) {
            this.sequence = this.sequence + 1L & this.bitsAllocator.getMaxSequence();
            if (this.sequence == 0L) {
                currentSecond = this.getNextSecond(this.lastSecond);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastSecond = currentSecond;
        return this.bitsAllocator.allocate(currentSecond - this.epochSeconds, this.workerId, this.sequence);
    }

    private long getNextSecond(long lastTimestamp) {
        long timestamp = this.getCurrentSecond();
        while (timestamp <= lastTimestamp) {
            timestamp = this.getCurrentSecond();
        }
        return timestamp;
    }

    private long getCurrentSecond() {
        long currentSecond = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        if (currentSecond - this.epochSeconds > this.bitsAllocator.getMaxDeltaSeconds()) {
            throw new UidGenerateException("Timestamp bits is exhausted. Refusing UID generate. Now: " + currentSecond);
        }
        return currentSecond;
    }

    public void setTimeBits(int timeBits) {
        if (timeBits > 0) {
            this.timeBits = timeBits;
        }
    }

    public void setWorkerBits(int workerBits) {
        if (workerBits > 0) {
            this.workerBits = workerBits;
        }
    }

    public void setSeqBits(int seqBits) {
        if (seqBits > 0) {
            this.seqBits = seqBits;
        }
    }

    public void setEpochStr(String epochStr) {
        if (StringUtils.isNotBlank((CharSequence)epochStr)) {
            this.epochStr = epochStr;
            try {
                Date epochDate = DateUtils.parseDate((String)epochStr, (String[])new String[]{"yyyy-MM-dd"});
                this.epochSeconds = TimeUnit.MILLISECONDS.toSeconds(epochDate.getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

