/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.snowflake.utils;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class NetUtils {
    public static NetworkInterface network;

    public static NetworkInterface getNetwork() throws SocketException {
        Enumeration<NetworkInterface> enu = NetworkInterface.getNetworkInterfaces();
        while (enu.hasMoreElements()) {
            NetworkInterface network = enu.nextElement();
            if (network.isLoopback()) continue;
            return network;
        }
        throw new RuntimeException("No validated local network!");
    }

    public static byte[] getMac() throws SocketException {
        return network.getHardwareAddress();
    }

    public static long getLongMac() throws SocketException {
        byte[] mac_bytes = NetUtils.getMac();
        return 0xFFL & (long)mac_bytes[0] | 0xFF00L & (long)mac_bytes[1] << 8 | 0xFF0000L & (long)mac_bytes[2] << 16 | 0xFF000000L & (long)mac_bytes[3] << 24 | 0xFF00000000L & (long)mac_bytes[4] << 32 | 0xFF0000000000L & (long)mac_bytes[5] << 40;
    }

    static {
        try {
            network = NetUtils.getNetwork();
        }
        catch (SocketException e) {
            throw new RuntimeException("fail to get local ip.");
        }
    }
}

