/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.index.generic;

import com.google.common.collect.ImmutableMap;
import io.georocket.index.Indexer;
import io.georocket.index.xml.XMLBoundingBoxIndexer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Arrays;
import java.util.Map;

public class BoundingBoxIndexer
implements Indexer {
    private static Logger log = LoggerFactory.getLogger(XMLBoundingBoxIndexer.class);
    protected boolean boundingBoxInitialized = false;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;

    protected void addToBoundingBox(double x, double y) {
        if (!this.boundingBoxInitialized) {
            this.minX = this.maxX = x;
            this.minY = this.maxY = y;
            this.boundingBoxInitialized = true;
        } else {
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
        }
    }

    private boolean validate() {
        return this.minX >= -180.0 && this.minY >= -90.0 && this.maxX <= 180.0 && this.maxY <= 90.0;
    }

    public Map<String, Object> getResult() {
        if (!this.boundingBoxInitialized) {
            return ImmutableMap.of();
        }
        if (!this.validate()) {
            this.boundingBoxInitialized = false;
            log.warn((Object)("Invalid bounding box [" + this.minX + "," + this.minY + "," + this.maxX + "," + this.maxY + "]. Values outside [-180.0, -90.0, 180.0, 90.0]. Skipping chunk."));
            return ImmutableMap.of();
        }
        return ImmutableMap.of((Object)"bbox", (Object)ImmutableMap.of((Object)"type", (Object)"envelope", (Object)"coordinates", Arrays.asList(Arrays.asList(this.minX, this.maxY), Arrays.asList(this.maxX, this.minY))));
    }
}

