/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.index.geojson;

import io.georocket.index.generic.BoundingBoxIndexer;
import io.georocket.index.xml.JsonIndexer;
import io.georocket.util.JsonStreamEvent;

public class GeoJsonBoundingBoxIndexer
extends BoundingBoxIndexer
implements JsonIndexer {
    private int level = 0;
    private int coordinatesLevel = -1;
    private double currentX;
    private int currentOrdinate = 0;

    public void onEvent(JsonStreamEvent event) {
        switch (event.getEvent()) {
            case 1: 
            case 3: {
                ++this.level;
                break;
            }
            case 5: {
                if (!"coordinates".equals(event.getCurrentValue())) break;
                this.currentOrdinate = 0;
                this.coordinatesLevel = this.level;
                break;
            }
            case 7: 
            case 8: {
                if (this.coordinatesLevel < 0) break;
                double d = ((Number)event.getCurrentValue()).doubleValue();
                if (this.currentOrdinate == 0) {
                    this.currentX = d;
                    this.currentOrdinate = 1;
                    break;
                }
                if (this.currentOrdinate != 1) break;
                this.addToBoundingBox(this.currentX, d);
                this.currentOrdinate = 0;
                break;
            }
            case 2: 
            case 4: {
                --this.level;
                if (this.coordinatesLevel != this.level) break;
                this.coordinatesLevel = -1;
                break;
            }
        }
    }
}

