/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.index.geojson;

import io.georocket.index.generic.GenericAttributeIndexer;
import io.georocket.index.xml.JsonIndexer;
import io.georocket.util.JsonStreamEvent;

public class GeoJsonGenericAttributeIndexer
extends GenericAttributeIndexer
implements JsonIndexer {
    private int level = 0;
    private int propertiesLevel = -1;
    private String currentKey;

    public void onEvent(JsonStreamEvent event) {
        switch (event.getEvent()) {
            case 1: 
            case 3: {
                ++this.level;
                break;
            }
            case 5: {
                if (this.propertiesLevel >= 0) {
                    if (this.propertiesLevel != this.level - 1) break;
                    this.currentKey = event.getCurrentValue().toString();
                    break;
                }
                if (!"properties".equals(event.getCurrentValue())) break;
                this.currentKey = null;
                this.propertiesLevel = this.level;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                String value = this.eventValueToString(event);
                if (this.currentKey == null || this.propertiesLevel != this.level - 1) break;
                this.put(this.currentKey, value);
                break;
            }
            case 2: 
            case 4: {
                --this.level;
                if (this.propertiesLevel != this.level) break;
                this.propertiesLevel = -1;
                break;
            }
        }
    }

    private String eventValueToString(JsonStreamEvent event) {
        switch (event.getEvent()) {
            case 6: 
            case 7: 
            case 8: {
                return String.valueOf(event.getCurrentValue());
            }
            case 9: {
                return "true";
            }
            case 10: {
                return "false";
            }
            case 11: {
                return "null";
            }
        }
        throw new IllegalArgumentException("Event type must be a value type");
    }
}

