/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.index.xml;

import com.google.common.collect.ImmutableMap;
import io.georocket.index.xml.XMLIndexer;
import io.georocket.util.XMLStreamEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GmlIdIndexer
implements XMLIndexer {
    private static final String NS_GML = "http://www.opengis.net/gml";
    private static final String NS_GML_3_2 = "http://www.opengis.net/gml/3.2";
    protected Set<String> ids = new HashSet<String>();
    private String firstNsToCheck = "http://www.opengis.net/gml";
    private String secondNsToCheck = "http://www.opengis.net/gml/3.2";

    public void onEvent(XMLStreamEvent event) {
        if (event.getEvent() == 1) {
            String gmlId = event.getXMLReader().getAttributeValue(this.firstNsToCheck, "id");
            if (gmlId == null && (gmlId = event.getXMLReader().getAttributeValue(this.secondNsToCheck, "id")) != null) {
                String t = this.secondNsToCheck;
                this.secondNsToCheck = this.firstNsToCheck;
                this.firstNsToCheck = t;
            }
            if (gmlId != null) {
                this.ids.add(gmlId);
            }
        }
    }

    public Map<String, Object> getResult() {
        return ImmutableMap.of((Object)"gmlIds", this.ids);
    }
}

