/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.index.xml;

import io.georocket.index.CRSAware;
import io.georocket.index.generic.BoundingBoxIndexer;
import io.georocket.index.xml.XMLIndexer;
import io.georocket.util.CompoundCRSDecoder;
import io.georocket.util.XMLStreamEvent;
import javax.xml.stream.XMLStreamReader;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class XMLBoundingBoxIndexer
extends BoundingBoxIndexer
implements XMLIndexer,
CRSAware {
    private static final CoordinateReferenceSystem WGS84 = DefaultGeographicCRS.WGS84;
    protected String crsStr;
    protected CoordinateReferenceSystem crs;
    protected boolean flippedCRS;
    protected MathTransform transform;
    private boolean parseCorner = false;
    private boolean parsePosList = false;
    protected int srsDimension = -1;
    private StringBuilder stringBuilder;

    public static boolean isFlippedCRS(CoordinateReferenceSystem crs) {
        AxisDirection direction;
        return crs.getCoordinateSystem().getDimension() == 2 && ((direction = crs.getCoordinateSystem().getAxis(0).getDirection()).equals((Object)AxisDirection.NORTH) || direction.equals((Object)AxisDirection.UP));
    }

    public void setFallbackCRSString(String crsStr) {
        this.handleSrsName(crsStr);
    }

    public void onEvent(XMLStreamEvent event) {
        XMLStreamReader reader = event.getXMLReader();
        if (event.getEvent() == 1) {
            this.handleSrsName(reader.getAttributeValue(null, "srsName"));
            String localName = reader.getLocalName();
            if (localName.equals("Envelope")) {
                this.handleSrsDimension(reader.getAttributeValue(null, "srsDimension"));
            } else if (localName.equals("lowerCorner") || localName.equals("upperCorner")) {
                this.parseCorner = true;
                this.stringBuilder = new StringBuilder();
            } else if (localName.equals("posList") || localName.equals("pos")) {
                this.parsePosList = true;
                this.stringBuilder = new StringBuilder();
                this.handleSrsDimension(reader.getAttributeValue(null, "srsDimension"));
            }
        } else if (event.getEvent() == 4) {
            if (this.parseCorner || this.parsePosList) {
                this.stringBuilder.append(reader.getText());
            }
        } else if (event.getEvent() == 2) {
            String localName = reader.getLocalName();
            if (localName.equals("Envelope")) {
                this.srsDimension = -1;
            } else if (localName.equals("lowerCorner") || localName.equals("upperCorner")) {
                this.handlePosList(this.stringBuilder.toString());
                this.stringBuilder = null;
                this.parseCorner = false;
            } else if (localName.equals("posList") || localName.equals("pos")) {
                this.handlePosList(this.stringBuilder.toString());
                this.stringBuilder = null;
                this.parsePosList = false;
                this.srsDimension = -1;
            }
        }
    }

    private void handleSrsName(String srsName) {
        if (srsName == null || srsName.isEmpty()) {
            return;
        }
        if (this.crsStr != null && this.crsStr.equals(srsName)) {
            return;
        }
        try {
            CoordinateReferenceSystem crs = CompoundCRSDecoder.isCompound(srsName) ? CompoundCRSDecoder.decode(srsName) : CRS.decode((String)srsName);
            SingleCRS hcrs = CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
            if (hcrs != null) {
                crs = hcrs;
            }
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)WGS84, (boolean)true);
            boolean flippedCRS = XMLBoundingBoxIndexer.isFlippedCRS(crs);
            this.crsStr = srsName;
            this.crs = crs;
            this.transform = transform;
            this.flippedCRS = flippedCRS;
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
    }

    private void handleSrsDimension(String srsDimension) {
        if (srsDimension == null || srsDimension.isEmpty()) {
            this.srsDimension = -1;
            return;
        }
        try {
            this.srsDimension = Integer.parseInt(srsDimension);
        }
        catch (NumberFormatException e) {
            this.srsDimension = -1;
        }
    }

    private void handlePosList(String text) {
        int i;
        if (this.crs == null || text == null || text.isEmpty()) {
            return;
        }
        String[] coordinates = text.trim().split("\\s+");
        int dim = this.srsDimension;
        if (dim <= 0) {
            if (coordinates.length % 3 == 0) {
                dim = 3;
            } else if (coordinates.length % 2 == 0) {
                dim = 2;
            } else {
                return;
            }
        }
        int count = coordinates.length / dim;
        double[] srcCoords = new double[count * 2];
        double[] dstCoords = new double[count * 2];
        try {
            for (i = 0; i < count; ++i) {
                int j1 = i * 2;
                int j2 = j1 + 1;
                if (this.flippedCRS) {
                    j2 = j1;
                    j1 = j2 + 1;
                }
                srcCoords[j1] = Double.parseDouble(coordinates[i * dim]);
                srcCoords[j2] = Double.parseDouble(coordinates[i * dim + 1]);
            }
        }
        catch (NumberFormatException e) {
            return;
        }
        try {
            this.transform.transform(srcCoords, 0, dstCoords, 0, count);
            for (i = 0; i < count; ++i) {
                this.addToBoundingBox(dstCoords[i * 2], dstCoords[i * 2 + 1]);
            }
        }
        catch (TransformException transformException) {
            // empty catch block
        }
    }
}

