/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.query;

import io.georocket.query.ElasticsearchQueryHelper;
import io.georocket.query.ElasticsearchQueryOptimizer;
import io.georocket.query.KeyValueQueryPart;
import io.georocket.query.QueryCompiler;
import io.georocket.query.QueryPart;
import io.georocket.query.StringQueryPart;
import io.georocket.query.parser.QueryBaseListener;
import io.georocket.query.parser.QueryLexer;
import io.georocket.query.parser.QueryParser;
import io.georocket.util.PathUtils;
import io.vertx.core.json.JsonObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class DefaultQueryCompiler
implements QueryCompiler {
    protected Collection<? extends QueryCompiler> queryCompilers = Collections.emptyList();

    public void setQueryCompilers(Collection<? extends QueryCompiler> queryCompilers) {
        this.queryCompilers = queryCompilers == null ? Collections.emptyList() : queryCompilers;
    }

    public JsonObject compileQuery(String search, String path, String keyExists) {
        JsonObject qb = this.compileQueryNoOptimize(search);
        ArrayList<JsonObject> filter = new ArrayList<JsonObject>();
        if (path != null && !path.equals("/")) {
            String prefix = PathUtils.addTrailingSlash(path);
            JsonObject qi = ElasticsearchQueryHelper.boolQuery((int)1);
            ElasticsearchQueryHelper.boolAddShould((JsonObject)qi, (JsonObject)ElasticsearchQueryHelper.termQuery((String)"path", (Object)path));
            ElasticsearchQueryHelper.boolAddShould((JsonObject)qi, (JsonObject)ElasticsearchQueryHelper.prefixQuery((String)"path", (Object)prefix));
            filter.add(qi);
        }
        if (keyExists != null) {
            filter.add(ElasticsearchQueryHelper.existsQuery((String)keyExists));
        }
        if (filter.size() > 0) {
            JsonObject qr = ElasticsearchQueryHelper.boolQuery((int)1);
            ElasticsearchQueryHelper.boolAddShould((JsonObject)qr, (JsonObject)qb);
            filter.forEach(q -> ElasticsearchQueryHelper.boolAddMust((JsonObject)qr, (JsonObject)q));
            return ElasticsearchQueryOptimizer.optimize((JsonObject)qr);
        }
        return ElasticsearchQueryOptimizer.optimize((JsonObject)qb);
    }

    public JsonObject compileQuery(String search, String path) {
        return this.compileQuery(search, path, null);
    }

    public JsonObject compileQuery(String search) {
        JsonObject r = this.compileQueryNoOptimize(search);
        return ElasticsearchQueryOptimizer.optimize((JsonObject)r);
    }

    protected JsonObject compileQueryNoOptimize(String search) {
        if (search == null || search.isEmpty()) {
            return ElasticsearchQueryHelper.matchAllQuery();
        }
        QueryLexer lexer = new QueryLexer((CharStream)new ANTLRInputStream(search.trim()));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        QueryParser parser = new QueryParser((TokenStream)tokens);
        QueryParser.QueryContext ctx = parser.query();
        QueryCompilerListener listener = new QueryCompilerListener();
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)listener, (ParseTree)ctx);
        if (listener.result.isEmpty()) {
            return ElasticsearchQueryHelper.matchAllQuery();
        }
        return listener.result.pop();
    }

    public QueryCompiler.MatchPriority getQueryPriority(String search) {
        return QueryCompiler.MatchPriority.MUST;
    }

    protected JsonObject makeQuery(QueryPart str) {
        JsonObject bqb = ElasticsearchQueryHelper.boolQuery((int)1);
        for (QueryCompiler queryCompiler : this.queryCompilers) {
            QueryCompiler.MatchPriority mp = queryCompiler.getQueryPriority(str);
            if (mp == null) continue;
            switch (mp) {
                case ONLY: {
                    return queryCompiler.compileQuery(str);
                }
                case SHOULD: {
                    ElasticsearchQueryHelper.boolAddShould((JsonObject)bqb, (JsonObject)queryCompiler.compileQuery(str));
                    break;
                }
                case MUST: {
                    ElasticsearchQueryHelper.boolAddMust((JsonObject)bqb, (JsonObject)queryCompiler.compileQuery(str));
                    break;
                }
            }
        }
        return bqb;
    }

    private class QueryCompilerListener
    extends QueryBaseListener {
        Deque<Logical> currentLogical = new ArrayDeque<Logical>();
        Deque<JsonObject> result = new ArrayDeque<JsonObject>();
        JsonObject currentKeyvalue = null;

        QueryCompilerListener() {
            this.currentLogical.push(Logical.OR);
        }

        private void enterLogical(Logical l) {
            JsonObject bqb = ElasticsearchQueryHelper.boolQuery((int)1);
            this.combine(bqb);
            this.result.push(bqb);
            this.currentLogical.push(l);
        }

        private void exitLogical() {
            this.currentLogical.pop();
            if (this.result.size() > 1) {
                this.result.pop();
            }
        }

        @Override
        public void enterOr(QueryParser.OrContext ctx) {
            this.enterLogical(Logical.OR);
        }

        @Override
        public void exitOr(QueryParser.OrContext ctx) {
            this.exitLogical();
        }

        @Override
        public void enterAnd(QueryParser.AndContext ctx) {
            this.enterLogical(Logical.AND);
        }

        @Override
        public void exitAnd(QueryParser.AndContext ctx) {
            this.exitLogical();
        }

        @Override
        public void enterNot(QueryParser.NotContext ctx) {
            this.enterLogical(Logical.NOT);
        }

        @Override
        public void exitNot(QueryParser.NotContext ctx) {
            this.exitLogical();
        }

        @Override
        public void enterString(QueryParser.StringContext ctx) {
            String str = ctx.getText();
            if (this.currentKeyvalue != null) {
                if (this.currentKeyvalue.containsKey("key")) {
                    this.currentKeyvalue.put("value", str);
                } else {
                    this.currentKeyvalue.put("key", str);
                }
            } else {
                StringQueryPart sqp = new StringQueryPart(str);
                JsonObject q = DefaultQueryCompiler.this.makeQuery((QueryPart)sqp);
                if (!this.combine(q)) {
                    this.result.push(q);
                }
            }
        }

        @Override
        public void enterLt(QueryParser.LtContext ctx) {
            this.currentKeyvalue = new JsonObject();
            this.currentKeyvalue.put("comp", KeyValueQueryPart.ComparisonOperator.LT.name());
        }

        @Override
        public void enterLte(QueryParser.LteContext ctx) {
            this.currentKeyvalue = new JsonObject();
            this.currentKeyvalue.put("comp", KeyValueQueryPart.ComparisonOperator.LTE.name());
        }

        @Override
        public void enterGt(QueryParser.GtContext ctx) {
            this.currentKeyvalue = new JsonObject();
            this.currentKeyvalue.put("comp", KeyValueQueryPart.ComparisonOperator.GT.name());
        }

        @Override
        public void enterGte(QueryParser.GteContext ctx) {
            this.currentKeyvalue = new JsonObject();
            this.currentKeyvalue.put("comp", KeyValueQueryPart.ComparisonOperator.GTE.name());
        }

        @Override
        public void enterEq(QueryParser.EqContext ctx) {
            this.currentKeyvalue = new JsonObject();
            this.currentKeyvalue.put("comp", KeyValueQueryPart.ComparisonOperator.EQ.name());
        }

        @Override
        public void exitKeyvalue(QueryParser.KeyvalueContext ctx) {
            KeyValueQueryPart kvqp = new KeyValueQueryPart(this.currentKeyvalue.getString("key"), this.currentKeyvalue.getString("value"), KeyValueQueryPart.ComparisonOperator.valueOf((String)this.currentKeyvalue.getString("comp")));
            JsonObject q = DefaultQueryCompiler.this.makeQuery((QueryPart)kvqp);
            if (!this.combine(q)) {
                this.result.push(q);
            }
            this.currentKeyvalue = null;
        }

        private boolean combine(JsonObject other) {
            JsonObject b = this.result.peek();
            if (b == null) {
                return false;
            }
            if (b.containsKey("bool")) {
                Logical l = this.currentLogical.peek();
                switch (l) {
                    case OR: {
                        ElasticsearchQueryHelper.boolAddShould((JsonObject)b, (JsonObject)other);
                        break;
                    }
                    case AND: {
                        ElasticsearchQueryHelper.boolAddMust((JsonObject)b, (JsonObject)other);
                        break;
                    }
                    case NOT: {
                        ElasticsearchQueryHelper.boolAddMustNot((JsonObject)b, (JsonObject)other);
                    }
                }
            } else {
                this.result.pop();
                JsonObject bqb = ElasticsearchQueryHelper.boolQuery((int)1);
                Logical l = this.currentLogical.peek();
                switch (l) {
                    case OR: {
                        ElasticsearchQueryHelper.boolAddShould((JsonObject)bqb, (JsonObject)b);
                        ElasticsearchQueryHelper.boolAddShould((JsonObject)bqb, (JsonObject)other);
                        break;
                    }
                    case AND: {
                        ElasticsearchQueryHelper.boolAddMust((JsonObject)bqb, (JsonObject)b);
                        ElasticsearchQueryHelper.boolAddMust((JsonObject)bqb, (JsonObject)other);
                        break;
                    }
                    case NOT: {
                        ElasticsearchQueryHelper.boolAddMustNot((JsonObject)bqb, (JsonObject)b);
                        ElasticsearchQueryHelper.boolAddMustNot((JsonObject)bqb, (JsonObject)other);
                    }
                }
                this.result.push(bqb);
            }
            return true;
        }
    }

    protected static enum Logical {
        OR,
        AND,
        NOT;

    }
}

