/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.util;

import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CompoundCRSDecoder {
    private static final String AUTHORITY = "urn:ogc:def";
    private static final String PREFIX = "urn:ogc:def:crs,";

    public static boolean isCompound(String code) {
        return code.trim().toLowerCase().startsWith(PREFIX);
    }

    public static CoordinateReferenceSystem decode(String code) throws FactoryException {
        if (!CompoundCRSDecoder.isCompound(code = code.trim())) {
            throw new NoSuchAuthorityCodeException("No compound CRS", AUTHORITY, code);
        }
        code = code.substring(PREFIX.length());
        String[] parts = code.split(",");
        CoordinateReferenceSystem[] crss = new CoordinateReferenceSystem[parts.length];
        for (int i = 0; i < crss.length; ++i) {
            crss[i] = CRS.decode((String)("urn:ogc:def:" + parts[i].trim()));
        }
        return new DefaultCompoundCRS("", crss);
    }
}

